package de.dass_it.vanhelsing.gui;

import java.util.ArrayList;

import de.dass_it.vanhelsing.gui.items.ConcreteUserObjectItem;
import de.dass_it.vanhelsing.gui.items.UserObjectItem;
import de.dass_it.www.vanhelsing.VanHelsingStub.ResourceAttributeType;
import de.dass_it.www.vanhelsing.VanHelsingStub.ResourceInfo;
/**
 * create a ConcreteUserObject out of a ResourceInfo oder ResourceAttributeType()
 * @author tgoecke
 *
 */
public class UserObjectItemFactory {
	/**
	 * creates a UserObjectItem based on a ResourceInfo object
	 * @param ri	ResourceInfo object to create the UserObjectItem
	 * @return	a new ConcreteUserObjectItem object
	 */
	public UserObjectItem createUserObjectItem(ResourceInfo ri){
		ConcreteUserObjectItem obj = new ConcreteUserObjectItem();
		obj.setResId(ri.getResId());
		obj.setResName(ri.getResName());
		obj.setResType(ri.getResType());
		obj.setDirector(ri.getDirector());
		return obj;
	}
	/**
	 * creates a UserObjectItem based on a ResourceAttributeType array and a ResourceInfo object
	 * @param ra	key value pair object 
	 * @param ri
	 * @return the created UserObjectItem
	 */
	public UserObjectItem createUserObjectItem(ResourceAttributeType ra[], ResourceInfo ri){
		ConcreteUserObjectItem obj = (ConcreteUserObjectItem)createUserObjectItem(ri);
		ArrayList<ViewItem> viewItemList = new ArrayList<ViewItem>();
		ViewItem vi;
		for (ResourceAttributeType attr : ra){
			vi = new ViewItem();
			vi.setDataType(BeanUtil.getDataType(obj.getResType(), attr.getKey()));
			vi.setRendererFlag(BeanUtil.getRenderer(obj.getResType(), attr.getKey()));
			vi.setRequired(BeanUtil.getRequired(obj.getResType(), attr.getKey()));
			vi.setKey(attr.getKey());
			vi.setKeyValue(attr.getValue());
			viewItemList.add(vi);
		}
		obj.setViewItemList(viewItemList);
		return obj;
	}
}
