/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.ldap;

import java.util.Hashtable;
import java.util.Map;
import java.util.StringTokenizer;
import javax.naming.AuthenticationException;
import javax.naming.CommunicationException;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.ldap.InitialLdapContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceAware;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.dao.DataAccessException;
import org.springframework.ldap.UncategorizedLdapException;
import org.springframework.ldap.core.DistinguishedName;
import org.springframework.security.BadCredentialsException;
import org.springframework.security.SpringSecurityMessageSource;
import org.springframework.security.ldap.InitialDirContextFactory;
import org.springframework.security.ldap.LdapUtils;
import org.springframework.security.ldap.SpringSecurityContextSource;
import org.springframework.util.Assert;

public class DefaultInitialDirContextFactory
implements InitialDirContextFactory,
SpringSecurityContextSource,
MessageSourceAware {
    private static final Log logger = LogFactory.getLog((Class)(class$org$springframework$security$ldap$DefaultInitialDirContextFactory == null ? (class$org$springframework$security$ldap$DefaultInitialDirContextFactory = DefaultInitialDirContextFactory.class$("org.springframework.security.ldap.DefaultInitialDirContextFactory")) : class$org$springframework$security$ldap$DefaultInitialDirContextFactory));
    private static final String CONNECTION_POOL_KEY = "com.sun.jndi.ldap.connect.pool";
    private static final String AUTH_TYPE_NONE = "none";
    private Map extraEnvVars = null;
    protected MessageSourceAccessor messages = SpringSecurityMessageSource.getAccessor();
    private String authenticationType = "simple";
    private String initialContextFactory = "com.sun.jndi.ldap.LdapCtxFactory";
    private String dirObjectFactoryClass = (class$org$springframework$ldap$core$support$DefaultDirObjectFactory == null ? (class$org$springframework$ldap$core$support$DefaultDirObjectFactory = DefaultInitialDirContextFactory.class$("org.springframework.ldap.core.support.DefaultDirObjectFactory")) : class$org$springframework$ldap$core$support$DefaultDirObjectFactory).getName();
    private String managerDn = null;
    private String managerPassword = "manager_password_not_set";
    private String providerUrl;
    private String rootDn = null;
    private boolean useConnectionPool = true;
    private boolean useLdapContext = false;
    static /* synthetic */ Class class$org$springframework$security$ldap$DefaultInitialDirContextFactory;
    static /* synthetic */ Class class$org$springframework$ldap$core$support$DefaultDirObjectFactory;

    public DefaultInitialDirContextFactory(String providerUrl) {
        this.setProviderUrl(providerUrl);
    }

    private void setProviderUrl(String providerUrl) {
        Assert.hasLength((String)providerUrl, (String)"An LDAP connection URL must be supplied.");
        this.providerUrl = providerUrl;
        StringTokenizer st = new StringTokenizer(providerUrl);
        while (st.hasMoreTokens()) {
            String url = st.nextToken();
            String urlRootDn = LdapUtils.parseRootDnFromUrl(url);
            logger.info((Object)(" URL '" + url + "', root DN is '" + urlRootDn + "'"));
            if (this.rootDn == null) {
                this.rootDn = urlRootDn;
                continue;
            }
            if (this.rootDn.equals(urlRootDn)) continue;
            throw new IllegalArgumentException("Root DNs must be the same when using multiple URLs");
        }
    }

    private String getProviderUrl() {
        return this.providerUrl;
    }

    private InitialDirContext connect(Hashtable env) {
        if (logger.isDebugEnabled()) {
            Hashtable envClone = (Hashtable)env.clone();
            if (envClone.containsKey("java.naming.security.credentials")) {
                envClone.put("java.naming.security.credentials", "******");
            }
            logger.debug((Object)("Creating InitialDirContext with environment " + envClone));
        }
        try {
            return this.useLdapContext ? new InitialLdapContext(env, null) : new InitialDirContext(env);
        }
        catch (NamingException ne) {
            if (ne instanceof AuthenticationException || ne instanceof OperationNotSupportedException) {
                throw new BadCredentialsException(this.messages.getMessage("DefaultIntitalDirContextFactory.badCredentials", "Bad credentials"), ne);
            }
            if (ne instanceof CommunicationException) {
                throw new UncategorizedLdapException(this.messages.getMessage("DefaultIntitalDirContextFactory.communicationFailure", "Unable to connect to LDAP server"), (Throwable)ne);
            }
            throw new UncategorizedLdapException(this.messages.getMessage("DefaultIntitalDirContextFactory.unexpectedException", "Failed to obtain InitialDirContext due to unexpected exception"), (Throwable)ne);
        }
    }

    protected Hashtable getEnvironment() {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.security.authentication", this.authenticationType);
        env.put("java.naming.factory.initial", this.initialContextFactory);
        env.put("java.naming.provider.url", this.getProviderUrl());
        if (this.useConnectionPool) {
            env.put(CONNECTION_POOL_KEY, "true");
        }
        if (this.extraEnvVars != null && this.extraEnvVars.size() > 0) {
            env.putAll(this.extraEnvVars);
        }
        return env;
    }

    public String getRootDn() {
        return this.rootDn;
    }

    public DirContext newInitialDirContext() {
        if (this.managerDn != null) {
            return this.newInitialDirContext(this.managerDn, this.managerPassword);
        }
        Hashtable env = this.getEnvironment();
        env.put("java.naming.security.authentication", AUTH_TYPE_NONE);
        return this.connect(env);
    }

    public DirContext newInitialDirContext(String username, String password) {
        Hashtable env = this.getEnvironment();
        if (!username.equals(this.managerDn)) {
            env.remove(CONNECTION_POOL_KEY);
        }
        env.put("java.naming.security.principal", username);
        env.put("java.naming.security.credentials", password);
        if (this.dirObjectFactoryClass != null) {
            env.put("java.naming.factory.object", this.dirObjectFactoryClass);
        }
        return this.connect(env);
    }

    public DirContext getReadOnlyContext() throws DataAccessException {
        return this.newInitialDirContext();
    }

    public DirContext getReadWriteContext() throws DataAccessException {
        return this.newInitialDirContext();
    }

    public void setAuthenticationType(String authenticationType) {
        Assert.hasLength((String)authenticationType, (String)"LDAP Authentication type must not be empty or null");
        this.authenticationType = authenticationType;
    }

    public void setExtraEnvVars(Map extraEnvVars) {
        Assert.notNull((Object)extraEnvVars, (String)"Extra environment map cannot be null.");
        this.extraEnvVars = extraEnvVars;
    }

    public void setInitialContextFactory(String initialContextFactory) {
        Assert.hasLength((String)initialContextFactory, (String)"Initial context factory name cannot be empty or null");
        this.initialContextFactory = initialContextFactory;
    }

    public void setManagerDn(String managerDn) {
        Assert.hasLength((String)managerDn, (String)"Manager user name  cannot be empty or null.");
        this.managerDn = managerDn;
    }

    public void setManagerPassword(String managerPassword) {
        Assert.hasLength((String)managerPassword, (String)"Manager password must not be empty or null.");
        this.managerPassword = managerPassword;
    }

    public void setMessageSource(MessageSource messageSource) {
        this.messages = new MessageSourceAccessor(messageSource);
    }

    public void setUseConnectionPool(boolean useConnectionPool) {
        this.useConnectionPool = useConnectionPool;
    }

    public void setUseLdapContext(boolean useLdapContext) {
        this.useLdapContext = useLdapContext;
    }

    public void setDirObjectFactory(String dirObjectFactory) {
        this.dirObjectFactoryClass = dirObjectFactory;
    }

    public DirContext getReadWriteContext(String userDn, Object credentials) {
        return this.newInitialDirContext(userDn, (String)credentials);
    }

    public DistinguishedName getBaseLdapPath() {
        return new DistinguishedName(this.rootDn);
    }

    public String getBaseLdapPathAsString() {
        return this.getBaseLdapPath().toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

