/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.lifecycle;

import com.sun.faces.lifecycle.Phase;
import com.sun.faces.util.FacesLogger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseId;

public class ProcessValidationsPhase
extends Phase {
    private static Logger LOGGER = FacesLogger.LIFECYCLE.getLogger();

    public void execute(FacesContext facesContext) throws FacesException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Entering ProcessValidationsPhase");
        }
        UIViewRoot component = facesContext.getViewRoot();
        assert (null != component);
        try {
            component.processValidators(facesContext);
        }
        catch (RuntimeException re) {
            String exceptionMessage = re.getMessage();
            if (null != exceptionMessage && LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, exceptionMessage, re);
            }
            throw new FacesException(exceptionMessage, (Throwable)re);
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Exiting ProcessValidationsPhase");
        }
    }

    public PhaseId getId() {
        return PhaseId.PROCESS_VALIDATIONS;
    }
}

