/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.webapp.http.servlet;

import com.icesoft.faces.webapp.http.common.Configuration;
import com.icesoft.faces.webapp.http.common.ConfigurationException;
import javax.servlet.ServletContext;

public class ServletContextConfiguration
extends Configuration {
    private final String name;
    private ServletContext context;

    public ServletContextConfiguration(String prefix, ServletContext context) {
        this.name = prefix;
        this.context = context;
    }

    public String getName() {
        return this.name;
    }

    public Configuration getChild(String child) throws ConfigurationException {
        String childName = this.postfixWith(child);
        String value = this.context.getInitParameter(childName);
        if (value == null) {
            throw new ConfigurationException("Cannot find parameter: " + childName);
        }
        return new ServletContextConfiguration(childName, this.context);
    }

    public Configuration[] getChildren(String name) throws ConfigurationException {
        return new Configuration[]{this.getChild(name)};
    }

    public String getAttribute(String paramName) throws ConfigurationException {
        String attributeName = this.postfixWith(paramName);
        String value = this.context.getInitParameter(attributeName);
        if (value == null) {
            throw new ConfigurationException("Cannot find parameter: " + attributeName);
        }
        return value;
    }

    public String getValue() throws ConfigurationException {
        String value = this.context.getInitParameter(this.name);
        if (value == null) {
            throw new ConfigurationException("Cannot find parameter: " + this.name);
        }
        return value;
    }

    private String postfixWith(String child) {
        return this.name + '.' + child;
    }
}

