/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.component.datapaginator;

import com.icesoft.faces.component.ExtendedAttributeConstants;
import com.icesoft.faces.component.datapaginator.DataPaginator;
import com.icesoft.faces.component.datapaginator.PaginatorActionEvent;
import com.icesoft.faces.component.ext.HtmlCommandLink;
import com.icesoft.faces.component.panelseries.UISeries;
import com.icesoft.faces.component.util.CustomComponentUtils;
import com.icesoft.faces.context.DOMContext;
import com.icesoft.faces.renderkit.dom_html_basic.DomBasicRenderer;
import com.icesoft.faces.renderkit.dom_html_basic.PassThruAttributeRenderer;
import com.icesoft.util.pooling.ClientIdPool;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.application.Application;
import javax.faces.component.UIComponent;
import javax.faces.component.UIParameter;
import javax.faces.context.FacesContext;
import javax.faces.event.FacesEvent;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DataPaginatorRenderer
extends DomBasicRenderer {
    public static final String RENDERER_TYPE = "com.icesoft.faces.DataScroller";
    protected static final String PAGE_NAVIGATION = "idx";
    private static final String[] PASSTHRU_EXCLUDE = new String[]{"style"};
    private static final String[] PASSTHRU = ExtendedAttributeConstants.getAttributes(5, PASSTHRU_EXCLUDE);

    public boolean getRendersChildren() {
        return true;
    }

    public void decode(FacesContext context, UIComponent component) {
        DataPaginatorRenderer.validateParameters((FacesContext)context, (UIComponent)component, (Class)DataPaginator.class);
        Map parameter = context.getExternalContext().getRequestParameterMap();
        String param = (String)parameter.get(component.getClientId(context));
        if (param != null && param.length() >= PAGE_NAVIGATION.length()) {
            if (param.startsWith(PAGE_NAVIGATION)) {
                component.queueEvent((FacesEvent)new PaginatorActionEvent(component, Integer.parseInt(param.substring(PAGE_NAVIGATION.length(), param.length()))));
            } else {
                component.queueEvent((FacesEvent)new PaginatorActionEvent(component, param));
            }
        }
    }

    protected void setVariables(FacesContext facescontext, DataPaginator scroller) throws IOException {
        String lastRowIndexVar;
        String firstRowIndexVar;
        String displayedRowsCountVar;
        String rowsCountVar;
        String pageIndexVar;
        Map requestMap = facescontext.getExternalContext().getRequestMap();
        String pageCountVar = scroller.getPageCountVar();
        if (pageCountVar != null) {
            int pageCount = scroller.getPageCount();
            requestMap.put(pageCountVar, new Integer(pageCount));
        }
        if ((pageIndexVar = scroller.getPageIndexVar()) != null) {
            int pageIndex = scroller.getPageIndex();
            if (pageIndex > scroller.getPageCount()) {
                pageIndex = scroller.getPageCount();
            }
            requestMap.put(pageIndexVar, new Integer(pageIndex));
        }
        if ((rowsCountVar = scroller.getRowsCountVar()) != null) {
            int rowsCount = scroller.getRowCount();
            requestMap.put(rowsCountVar, new Integer(rowsCount));
        }
        if ((displayedRowsCountVar = scroller.getDisplayedRowsCountVar()) != null) {
            int max;
            int displayedRowsCount = scroller.getRows();
            if (displayedRowsCount > (max = scroller.getRowCount() - scroller.getFirstRow())) {
                displayedRowsCount = max;
            }
            requestMap.put(displayedRowsCountVar, new Integer(displayedRowsCount));
        }
        if ((firstRowIndexVar = scroller.getFirstRowIndexVar()) != null) {
            int firstRowIndex = scroller.getFirstRow();
            firstRowIndex = scroller.getRowCount() > 0 ? ++firstRowIndex : 0;
            requestMap.put(firstRowIndexVar, new Integer(firstRowIndex));
        }
        if ((lastRowIndexVar = scroller.getLastRowIndexVar()) != null) {
            int count;
            int lastRowIndex = scroller.getFirstRow() + scroller.getRows();
            if (lastRowIndex > (count = scroller.getRowCount())) {
                lastRowIndex = count;
            }
            requestMap.put(lastRowIndexVar, new Integer(lastRowIndex));
        }
    }

    public void removeVariables(FacesContext facescontext, UIComponent uiComponent) throws IOException {
        String lastRowIndexVar;
        String firstRowIndexVar;
        String displayedRowsCountVar;
        String rowsCountVar;
        String pageIndexVar;
        DataPaginator scroller = (DataPaginator)uiComponent;
        Map requestMap = facescontext.getExternalContext().getRequestMap();
        String pageCountVar = scroller.getPageCountVar();
        if (pageCountVar != null) {
            requestMap.remove(pageCountVar);
        }
        if ((pageIndexVar = scroller.getPageIndexVar()) != null) {
            requestMap.remove(pageIndexVar);
        }
        if ((rowsCountVar = scroller.getRowsCountVar()) != null) {
            requestMap.remove(rowsCountVar);
        }
        if ((displayedRowsCountVar = scroller.getDisplayedRowsCountVar()) != null) {
            requestMap.remove(displayedRowsCountVar);
        }
        if ((firstRowIndexVar = scroller.getFirstRowIndexVar()) != null) {
            requestMap.remove(firstRowIndexVar);
        }
        if ((lastRowIndexVar = scroller.getLastRowIndexVar()) != null) {
            requestMap.remove(lastRowIndexVar);
        }
    }

    public void encodeBegin(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        DataPaginatorRenderer.validateParameters((FacesContext)facesContext, (UIComponent)uiComponent, (Class)DataPaginator.class);
        DataPaginator scroller = (DataPaginator)uiComponent;
        if (!scroller.isModelResultSet()) {
            super.encodeBegin(facesContext, uiComponent);
            if (scroller.getChildCount() > 0) {
                List kids = scroller.getChildren();
                for (int i = 0; i < kids.size(); ++i) {
                    UIComponent kid = (UIComponent)kids.get(i);
                    if (kid.getFamily().equalsIgnoreCase("javax.faces.Output")) continue;
                    scroller.getChildren().remove(kids.get(i));
                }
            }
            scroller.getUIData().setValue(null);
            scroller.getUIData().setRowIndex(-1);
            ((UISeries)scroller.getUIData()).ensureFirstRowInRange();
            this.setVariables(facesContext, scroller);
        }
    }

    public void encodeChildren(FacesContext facescontext, UIComponent uicomponent) throws IOException {
        DataPaginatorRenderer.validateParameters((FacesContext)facescontext, (UIComponent)uicomponent, (Class)DataPaginator.class);
        DataPaginator scroller = (DataPaginator)uicomponent;
        if (!scroller.isModelResultSet()) {
            boolean singlePageScroller;
            boolean bl = singlePageScroller = scroller.getPageCount() <= 1 && scroller.getRowsCountVar() == null && scroller.getDisplayedRowsCountVar() == null;
            if (!singlePageScroller) {
                CustomComponentUtils.renderChildren(facescontext, uicomponent);
            }
        }
    }

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        DataPaginatorRenderer.validateParameters((FacesContext)facesContext, (UIComponent)uiComponent, (Class)DataPaginator.class);
        DataPaginator scroller = (DataPaginator)uiComponent;
        if (scroller.getUIData() == null) {
            return;
        }
        this.renderScroller(facesContext, uiComponent);
        if (!scroller.isModelResultSet()) {
            this.removeVariables(facesContext, uiComponent);
        }
    }

    protected void renderScroller(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        Element table;
        DataPaginator scroller = (DataPaginator)uiComponent;
        if (!scroller.isModelResultSet() && !scroller.isRenderFacetsIfSinglePage() && scroller.getPageCount() <= 1) {
            return;
        }
        if (scroller.getFacets().size() <= 0) {
            return;
        }
        DOMContext domContext = DOMContext.attachDOMContext((FacesContext)facesContext, (UIComponent)scroller);
        if (!domContext.isInitialized()) {
            table = domContext.createRootElement("table");
            DataPaginatorRenderer.setRootElementId((FacesContext)facesContext, (Element)table, (UIComponent)scroller);
            PassThruAttributeRenderer.renderHtmlAttributes((FacesContext)facesContext, (UIComponent)scroller, (String[])PASSTHRU);
        }
        table = (Element)domContext.getRootNode();
        DOMContext.removeChildren((Node)table);
        Element tr = domContext.createElement("tr");
        table.appendChild(tr);
        String styleClass = scroller.getStyleClass();
        table.setAttribute("class", styleClass);
        String style = scroller.getStyle();
        if (style != null && style.length() > 0) {
            table.setAttribute("style", style);
        } else {
            table.removeAttribute("style");
        }
        String scrollButtonCellClass = scroller.getscrollButtonCellClass();
        this.handleFacet(facesContext, scroller, domContext, table, tr, scrollButtonCellClass, scroller.getFirst(), DataPaginator.FACET_FIRST);
        if (scroller.isVertical()) {
            tr = null;
        }
        this.handleFacet(facesContext, scroller, domContext, table, tr, scrollButtonCellClass, scroller.getFastRewind(), DataPaginator.FACET_FAST_REWIND);
        this.handleFacet(facesContext, scroller, domContext, table, tr, scrollButtonCellClass, scroller.getPrevious(), DataPaginator.FACET_PREVIOUS);
        if (!scroller.isModelResultSet() && scroller.isPaginator()) {
            if (scroller.isVertical()) {
                tr = domContext.createElement("tr");
                table.appendChild(tr);
            }
            Element td = domContext.createElement("td");
            tr.appendChild(td);
            Element paginatorTable = domContext.createElement("table");
            td.appendChild(paginatorTable);
            this.renderPaginator(facesContext, uiComponent, paginatorTable, domContext);
        }
        this.handleFacet(facesContext, scroller, domContext, table, tr, scrollButtonCellClass, scroller.getNext(), DataPaginator.FACET_NEXT);
        this.handleFacet(facesContext, scroller, domContext, table, tr, scrollButtonCellClass, scroller.getFastForward(), DataPaginator.FACET_FAST_FORWARD);
        this.handleFacet(facesContext, scroller, domContext, table, tr, scrollButtonCellClass, scroller.getLast(), DataPaginator.FACET_LAST);
        domContext.stepOver();
    }

    protected void handleFacet(FacesContext facesContext, DataPaginator scroller, DOMContext domContext, Element table, Element tr, String scrollButtonCellClass, UIComponent facetComp, String facetName) throws IOException {
        if (facetComp != null) {
            if (tr == null) {
                tr = domContext.createElement("tr");
                table.appendChild(tr);
            }
            Element td = domContext.createElement("td");
            td.setAttribute("class", scrollButtonCellClass);
            tr.appendChild(td);
            domContext.setCursorParent((Node)td);
            this.renderFacet(facesContext, scroller, facetComp, facetName);
        }
    }

    protected void renderFacet(FacesContext facesContext, DataPaginator scroller, UIComponent facetComp, String facetName) throws IOException {
        HtmlCommandLink link = this.getLink(facesContext, scroller, facetName);
        if (scroller.isDisabled() || !scroller.isModelResultSet() && scroller.getPageCount() <= 1 || scroller.getPageIndex() == 1 && (DataPaginator.FACET_FAST_REWIND.equals(facetName) || DataPaginator.FACET_FIRST.equals(facetName) || DataPaginator.FACET_PREVIOUS.equals(facetName)) || scroller.getPageIndex() == scroller.getPageCount() && (DataPaginator.FACET_FAST_FORWARD.equals(facetName) || DataPaginator.FACET_LAST.equals(facetName) || DataPaginator.FACET_NEXT.equals(facetName))) {
            link.setDisabled(true);
        } else {
            link.setDisabled(false);
        }
        link.encodeBegin(facesContext);
        DataPaginatorRenderer.encodeParentAndChildren((FacesContext)facesContext, (UIComponent)facetComp);
        link.encodeEnd(facesContext);
    }

    protected void renderPaginator(FacesContext facesContext, UIComponent uiComponent, Element paginatorTable, DOMContext domContext) throws IOException {
        int start;
        int pages;
        int pageCount;
        DataPaginator scroller = (DataPaginator)uiComponent;
        int maxPages = scroller.getPaginatorMaxPages();
        if (maxPages <= 1) {
            maxPages = 2;
        }
        if ((pageCount = scroller.getPageCount()) <= 1) {
            return;
        }
        int pageIndex = scroller.getPageIndex();
        if (pageIndex > pageCount) {
            pageIndex = pageCount;
        }
        int delta = maxPages / 2;
        if (pageCount > maxPages && pageIndex > delta) {
            pages = maxPages;
            start = pageIndex - pages / 2 - 1;
            if (start + pages > pageCount) {
                start = pageCount - pages;
            }
        } else {
            pages = pageCount < maxPages ? pageCount : maxPages;
            start = 0;
        }
        String styleClass = scroller.getPaginatorTableClass();
        paginatorTable.setAttribute("class", styleClass);
        Element tr = null;
        if (!scroller.isVertical()) {
            tr = domContext.createElement("tr");
            paginatorTable.appendChild(tr);
        }
        UIComponent form = DataPaginatorRenderer.findForm((UIComponent)scroller);
        String formId = null;
        if (form == null) {
            throw new FacesException("Form tag is missing");
        }
        formId = form.getClientId(facesContext);
        int size = start + pages;
        for (int i = start; i < size; ++i) {
            int idx = i + 1;
            if (scroller.isVertical()) {
                tr = domContext.createElement("tr");
                paginatorTable.appendChild(tr);
            }
            Element td = domContext.createElement("td");
            tr.appendChild(td);
            domContext.setCursorParent((Node)td);
            String cStyleClass = idx == pageIndex ? scroller.getPaginatorActiveColumnClass() : scroller.getPaginatorColumnClass();
            if (cStyleClass != null) {
                td.setAttribute("class", cStyleClass);
            }
            Element link = this.getLink(facesContext, domContext, scroller, Integer.toString(idx), idx, formId);
            td.appendChild(link);
        }
    }

    protected Element getLink(FacesContext facesContext, DOMContext domContext, DataPaginator scroller, String text, int pageIndex, String formId) {
        Element link = domContext.createElement("a");
        if (text != null) {
            link.appendChild(domContext.createTextNode(text));
        }
        String linkid = ClientIdPool.get((String)(scroller.getClientId(facesContext) + PAGE_NAVIGATION + Integer.toString(pageIndex)));
        String onClick = "document.forms['" + formId + "']['" + scroller.getClientId(facesContext) + "'].value='" + PAGE_NAVIGATION + text + "'" + ";iceSubmit(" + " document.forms['" + formId + "']," + " this,event); " + "return false;";
        link.setAttribute("id", linkid);
        if (scroller.isDisabled()) {
            link.removeAttribute("onclick");
        } else {
            link.setAttribute("onclick", onClick);
        }
        link.setAttribute("href", "javascript:;");
        PassThruAttributeRenderer.renderOnFocus((UIComponent)scroller, (Element)link);
        PassThruAttributeRenderer.renderOnBlur((Element)link);
        return link;
    }

    protected HtmlCommandLink getLink(FacesContext facesContext, DataPaginator scroller, String facetName) {
        Application application = facesContext.getApplication();
        HtmlCommandLink link = (HtmlCommandLink)application.createComponent("com.icesoft.faces.HtmlCommandLink");
        String id = scroller.getId() + facetName;
        link.setId(id);
        link.setTransient(true);
        UIParameter parameter = (UIParameter)application.createComponent("javax.faces.Parameter");
        parameter.setId(id + "_param");
        parameter.setTransient(true);
        parameter.setName(scroller.getClientId(facesContext));
        parameter.setValue((Object)facetName);
        List children = link.getChildren();
        children.add(parameter);
        for (int i = 0; i < scroller.getChildCount(); ++i) {
            UIComponent comp = (UIComponent)scroller.getChildren().get(i);
            if (!comp.getId().equals(id)) continue;
            scroller.getChildren().remove(i);
            break;
        }
        scroller.getChildren().add(link);
        return link;
    }
}

