/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.push.server;

import com.icesoft.net.messaging.Message;
import com.icesoft.net.messaging.MessageHandler;
import com.icesoft.net.messaging.MessageSelector;
import com.icesoft.net.messaging.TextMessage;
import com.icesoft.net.messaging.expression.Equal;
import com.icesoft.net.messaging.expression.Expression;
import com.icesoft.net.messaging.expression.Identifier;
import com.icesoft.net.messaging.expression.Literal;
import com.icesoft.net.messaging.expression.StringLiteral;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.icefaces.push.server.AbstractContextEventMessageHandler;

public class BufferedContextEventsMessageHandler
extends AbstractContextEventMessageHandler
implements MessageHandler {
    protected static final String MESSAGE_TYPE = "BufferedContextEvents";
    private static final Log LOG = LogFactory.getLog((Class)BufferedContextEventsMessageHandler.class);
    private static MessageSelector messageSelector = new MessageSelector((Expression)new Equal(new Identifier("message_type"), (Literal)new StringLiteral("BufferedContextEvents")));

    public BufferedContextEventsMessageHandler() {
        super(messageSelector);
    }

    public void handle(Message message) {
        if (message == null) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Handling:\r\n\r\n" + message));
        }
        if (message instanceof TextMessage) {
            StringTokenizer _messages = new StringTokenizer(((TextMessage)message).getText());
            while (_messages.hasMoreTokens()) {
                int i;
                MessageHandler.Callback[] _callbacks;
                StringTokenizer _tokens = new StringTokenizer(_messages.nextToken(), ";");
                String _event = _tokens.nextToken();
                if (_event.equals("ICEfacesIDRetrieved")) {
                    _callbacks = this.getCallbacks(message);
                    for (i = 0; i < _callbacks.length; ++i) {
                        ((Callback)_callbacks[i]).iceFacesIdRetrieved(message.getStringProperty("source_servletContextPath"), _tokens.nextToken());
                    }
                    continue;
                }
                if (_event.equals("ViewNumberDisposed")) {
                    _callbacks = this.getCallbacks(message);
                    for (i = 0; i < _callbacks.length; ++i) {
                        ((Callback)_callbacks[i]).viewNumberDisposed(message.getStringProperty("source_servletContextPath"), _tokens.nextToken(), _tokens.nextToken());
                    }
                    continue;
                }
                if (!_event.equals("ViewNumberRetrieved")) continue;
                _callbacks = this.getCallbacks(message);
                for (i = 0; i < _callbacks.length; ++i) {
                    ((Callback)_callbacks[i]).viewNumberRetrieved(message.getStringProperty("source_servletContextPath"), _tokens.nextToken(), _tokens.nextToken());
                }
            }
        }
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public static interface Callback
    extends AbstractContextEventMessageHandler.Callback {
    }
}

