/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.push.server;

import com.icesoft.net.messaging.Message;
import com.icesoft.net.messaging.MessageHandler;
import com.icesoft.net.messaging.MessageSelector;
import com.icesoft.net.messaging.TextMessage;
import com.icesoft.net.messaging.expression.Equal;
import com.icesoft.net.messaging.expression.Expression;
import com.icesoft.net.messaging.expression.Identifier;
import com.icesoft.net.messaging.expression.Literal;
import com.icesoft.net.messaging.expression.StringLiteral;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.icefaces.push.server.AbstractContextEventMessageHandler;

public class ContextEventMessageHandler
extends AbstractContextEventMessageHandler
implements MessageHandler {
    protected static final String MESSAGE_TYPE = "ContextEvent";
    private static final Log LOG = LogFactory.getLog((Class)ContextEventMessageHandler.class);
    private static MessageSelector messageSelector = new MessageSelector((Expression)new Equal(new Identifier("message_type"), (Literal)new StringLiteral("ContextEvent")));

    public ContextEventMessageHandler() {
        super(messageSelector);
    }

    public void handle(Message message) {
        block6: {
            String _event;
            StringTokenizer _tokens;
            block9: {
                block8: {
                    block7: {
                        if (message == null) {
                            return;
                        }
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("Handling:\r\n\r\n" + message));
                        }
                        if (!(message instanceof TextMessage)) break block6;
                        _tokens = new StringTokenizer(((TextMessage)message).getText(), ";");
                        _event = _tokens.nextToken();
                        if (!_event.equals("ICEfacesIDDisposed")) break block7;
                        LOG.debug((Object)"Handling ICEfaces ID Disposed message...");
                        MessageHandler.Callback[] _callbacks = this.getCallbacks(message);
                        for (int i = 0; i < _callbacks.length; ++i) {
                            ((Callback)_callbacks[i]).iceFacesIdDisposed(message.getStringProperty("source_servletContextPath"), _tokens.nextToken());
                        }
                        break block6;
                    }
                    if (!_event.equals("ICEfacesIDRetrieved")) break block8;
                    LOG.debug((Object)"Handling ICEfaces ID Retrieved message...");
                    MessageHandler.Callback[] _callbacks = this.getCallbacks(message);
                    for (int i = 0; i < _callbacks.length; ++i) {
                        ((Callback)_callbacks[i]).iceFacesIdRetrieved(message.getStringProperty("source_servletContextPath"), _tokens.nextToken());
                    }
                    break block6;
                }
                if (!_event.equals("ViewNumberDisposed")) break block9;
                LOG.debug((Object)"Handling View Number Disposed message...");
                MessageHandler.Callback[] _callbacks = this.getCallbacks(message);
                for (int i = 0; i < _callbacks.length; ++i) {
                    ((Callback)_callbacks[i]).viewNumberDisposed(message.getStringProperty("source_servletContextPath"), _tokens.nextToken(), _tokens.nextToken());
                }
                break block6;
            }
            if (!_event.equals("ViewNumberRetrieved")) break block6;
            LOG.debug((Object)"Handling View Number Retrieved message...");
            MessageHandler.Callback[] _callbacks = this.getCallbacks(message);
            for (int i = 0; i < _callbacks.length; ++i) {
                ((Callback)_callbacks[i]).viewNumberRetrieved(message.getStringProperty("source_servletContextPath"), _tokens.nextToken(), _tokens.nextToken());
            }
        }
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public static interface Callback
    extends AbstractContextEventMessageHandler.Callback {
    }
}

