/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.util;

import java.util.HashSet;
import java.util.Set;
import org.springframework.security.Authentication;
import org.springframework.security.GrantedAuthority;
import org.springframework.security.GrantedAuthorityImpl;
import org.springframework.security.context.SecurityContextHolder;
import org.springframework.util.StringUtils;

public abstract class AuthorityUtils {
    public static final GrantedAuthority[] NO_AUTHORITIES = new GrantedAuthority[0];

    public static boolean userHasAuthority(String authority) {
        GrantedAuthority[] authorities = AuthorityUtils.getUserAuthorities();
        for (int i = 0; i < authorities.length; ++i) {
            if (!authority.equals(authorities[i].getAuthority())) continue;
            return true;
        }
        return false;
    }

    private static GrantedAuthority[] getUserAuthorities() {
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        if (auth == null || auth.getAuthorities() == null) {
            return NO_AUTHORITIES;
        }
        return auth.getAuthorities();
    }

    public static GrantedAuthority[] commaSeparatedStringToAuthorityArray(String authorityString) {
        String[] authorityStrings = StringUtils.tokenizeToStringArray((String)authorityString, (String)",");
        GrantedAuthority[] authorities = new GrantedAuthority[authorityStrings.length];
        for (int i = 0; i < authorityStrings.length; ++i) {
            authorities[i] = new GrantedAuthorityImpl(authorityStrings[i]);
        }
        return authorities;
    }

    public static Set authorityArrayToSet(GrantedAuthority[] authorities) {
        HashSet<String> set = new HashSet<String>(authorities.length);
        for (int i = 0; i < authorities.length; ++i) {
            set.add(authorities[i].getAuthority());
        }
        return set;
    }

    public static GrantedAuthority[] stringArrayToAuthorityArray(String[] roles) {
        GrantedAuthority[] authorities = new GrantedAuthority[roles.length];
        for (int i = 0; i < roles.length; ++i) {
            authorities[i] = new GrantedAuthorityImpl(roles[i]);
        }
        return authorities;
    }
}

