/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.webapp.command;

import com.icesoft.faces.util.DOMUtils;
import com.icesoft.faces.webapp.command.AbstractCommand;
import com.icesoft.faces.webapp.command.Command;
import com.icesoft.faces.webapp.command.Macro;
import com.icesoft.faces.webapp.command.NOOP;
import com.icesoft.faces.webapp.command.Pong;
import com.icesoft.faces.webapp.command.Redirect;
import com.icesoft.faces.webapp.command.Reload;
import com.icesoft.faces.webapp.command.SessionExpired;
import com.icesoft.faces.webapp.command.SetCookie;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Pattern;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public class UpdateElements
extends AbstractCommand {
    private static final Pattern START_CDATA = Pattern.compile("<\\!\\[CDATA\\[");
    private static final Pattern END_CDATA = Pattern.compile("\\]\\]>");
    private Element[] updates;

    public UpdateElements(Element[] updates) {
        this.updates = updates;
    }

    public Command coalesceWithPrevious(UpdateElements updateElementsCommand) {
        ArrayList<Element> coallescedUpdates = new ArrayList<Element>();
        Element[] previousUpdates = updateElementsCommand.updates;
        for (int i = 0; i < previousUpdates.length; ++i) {
            Element previousUpdate = previousUpdates[i];
            boolean overriden = false;
            for (int j = 0; j < this.updates.length; ++j) {
                Element update = this.updates[j];
                if (!update.getAttribute("id").equals(previousUpdate.getAttribute("id"))) continue;
                overriden = true;
                break;
            }
            if (overriden) continue;
            coallescedUpdates.add(previousUpdate);
        }
        coallescedUpdates.addAll(Arrays.asList(this.updates));
        return new UpdateElements(coallescedUpdates.toArray(new Element[coallescedUpdates.size()]));
    }

    public Command coalesceWithNext(Command command) {
        return command.coalesceWithPrevious(this);
    }

    public Command coalesceWithPrevious(Macro macro) {
        macro.addCommand(this);
        return macro;
    }

    public Command coalesceWithPrevious(Redirect redirect) {
        return redirect;
    }

    public Command coalesceWithPrevious(Reload reload) {
        return reload;
    }

    public Command coalesceWithPrevious(SessionExpired sessionExpired) {
        return sessionExpired;
    }

    public Command coalesceWithPrevious(SetCookie setCookie) {
        Macro macro = new Macro();
        macro.addCommand(this);
        macro.addCommand(setCookie);
        return macro;
    }

    public Command coalesceWithPrevious(Pong pong) {
        Macro macro = new Macro();
        macro.addCommand(this);
        macro.addCommand(pong);
        return macro;
    }

    public Command coalesceWithPrevious(NOOP noop) {
        return this;
    }

    public void serializeTo(Writer writer) throws IOException {
        writer.write("<updates>");
        for (int i = 0; i < this.updates.length; ++i) {
            Element update = this.updates[i];
            if (update == null) continue;
            writer.write("<update address=\"");
            writer.write(update.getAttribute("id"));
            writer.write("\" tag=\"" + update.getTagName() + "\">");
            NamedNodeMap attributes = update.getAttributes();
            for (int j = 0; j < attributes.getLength(); ++j) {
                Attr attribute = (Attr)attributes.item(j);
                writer.write("<attribute name=\"");
                writer.write(attribute.getName());
                String value = attribute.getValue();
                if ("".equals(value)) {
                    writer.write("\"/>");
                    continue;
                }
                writer.write("\"><![CDATA[");
                writer.write(DOMUtils.escapeAnsi(value));
                writer.write("]]></attribute>");
            }
            String content = DOMUtils.childrenToString(update);
            if ("".equals(content)) {
                writer.write("<content/>");
            } else {
                writer.write("<content><![CDATA[");
                content = START_CDATA.matcher(content).replaceAll("<!#cdata#");
                content = END_CDATA.matcher(content).replaceAll("##>");
                writer.write(content);
                writer.write("]]></content>");
            }
            writer.write("</update>");
        }
        writer.write("</updates>");
    }
}

