/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.webapp.http.servlet;

import com.icesoft.faces.env.Authorization;
import com.icesoft.faces.webapp.http.servlet.PseudoServlet;
import com.icesoft.util.ThreadLocalUtility;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class SessionDispatcher
implements PseudoServlet {
    private static final Log Log = LogFactory.getLog((Class)SessionDispatcher.class);
    private static final Map SessionMonitors = new HashMap();
    private final Map sessionBoundServers = new HashMap();
    private final Map activeRequests = new HashMap();
    private ServletContext context;
    static /* synthetic */ Class class$com$icesoft$faces$webapp$http$servlet$SessionDispatcher$Monitor;

    public SessionDispatcher(ServletContext context) {
        this.associateSessionDispatcher(context);
        this.context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession(true);
        this.checkSession(session);
        String id = session.getId();
        try {
            this.addRequest(id, request);
            this.lookupServer(session).service(request, response);
        }
        finally {
            this.removeRequest(id, request);
        }
    }

    public void shutdown() {
        Iterator i = this.sessionBoundServers.values().iterator();
        while (i.hasNext()) {
            PseudoServlet pseudoServlet = (PseudoServlet)i.next();
            pseudoServlet.shutdown();
        }
    }

    protected abstract PseudoServlet newServer(HttpSession var1, Monitor var2, Authorization var3) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkSession(HttpSession session) throws Exception {
        Monitor monitor;
        final String id = session.getId();
        Map map = SessionMonitors;
        synchronized (map) {
            if (!SessionMonitors.containsKey(id)) {
                monitor = new Monitor(session);
                SessionMonitors.put(id, monitor);
            } else {
                monitor = (Monitor)SessionMonitors.get(id);
            }
            monitor.addInSessionContext(this.context);
        }
        map = this.sessionBoundServers;
        synchronized (map) {
            if (!this.sessionBoundServers.containsKey(id)) {
                this.sessionBoundServers.put(id, this.newServer(session, monitor, new Authorization(){

                    public boolean isUserInRole(String role) {
                        return SessionDispatcher.this.inRole(id, role);
                    }
                }));
            }
        }
    }

    protected PseudoServlet lookupServer(HttpSession session) {
        return this.lookupServer(session.getId());
    }

    protected PseudoServlet lookupServer(String sessionId) {
        return (PseudoServlet)this.sessionBoundServers.get(sessionId);
    }

    private void sessionShutdown(HttpSession session) {
        PseudoServlet servlet = (PseudoServlet)this.sessionBoundServers.get(session.getId());
        servlet.shutdown();
    }

    private void sessionDestroy(HttpSession session) {
        this.sessionBoundServers.remove(session.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRequest(String key, HttpServletRequest request) {
        Map map = this.activeRequests;
        synchronized (map) {
            if (this.activeRequests.containsKey(key)) {
                List requests = (List)this.activeRequests.get(key);
                requests.add(request);
            } else {
                ArrayList<HttpServletRequest> requests = new ArrayList<HttpServletRequest>();
                requests.add(request);
                this.activeRequests.put(key, requests);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeRequest(String key, HttpServletRequest request) {
        Map map = this.activeRequests;
        synchronized (map) {
            List requests = (List)this.activeRequests.get(key);
            if (requests != null) {
                requests.remove(request);
                if (requests.isEmpty()) {
                    this.activeRequests.remove(key);
                }
            }
        }
    }

    private boolean inRole(String sessionID, String role) {
        Collection sessionRequests = (Collection)this.activeRequests.get(sessionID);
        if (sessionRequests != null && !sessionRequests.isEmpty()) {
            Iterator i = new ArrayList(sessionRequests).iterator();
            while (i.hasNext()) {
                try {
                    HttpServletRequest request = (HttpServletRequest)i.next();
                    if (!request.isUserInRole(role)) continue;
                    return true;
                }
                catch (Throwable t) {
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void notifySessionShutdown(HttpSession session, ServletContext context) {
        Log.debug((Object)("Shutting down session: " + session.getId()));
        String sessionID = session.getId();
        if (!SessionMonitors.containsKey(sessionID)) {
            Log.debug((Object)("Session: " + sessionID + " already shutdown, skipping"));
            return;
        }
        SessionDispatcher sessionDispatcher = SessionDispatcher.lookupSessionDispatcher(context);
        try {
            sessionDispatcher.sessionShutdown(session);
        }
        catch (Exception e) {
            Log.error((Object)e);
        }
        Map map = SessionMonitors;
        synchronized (map) {
            try {
                sessionDispatcher.sessionDestroy(session);
            }
            catch (Exception e) {
                Log.error((Object)e);
            }
            SessionMonitors.remove(sessionID);
        }
    }

    public static PseudoServlet getSingletonSessionServer(HttpSession session, ServletContext context) {
        return SessionDispatcher.lookupSessionDispatcher(context).lookupServer(session);
    }

    public static PseudoServlet getSingletonSessionServer(String sessionId, Map applicationMap) {
        return SessionDispatcher.lookupSessionDispatcher(applicationMap).lookupServer(sessionId);
    }

    public static PseudoServlet getSingletonSessionServer(String sessionId, ServletContext servletContext) {
        return SessionDispatcher.lookupSessionDispatcher(servletContext).lookupServer(sessionId);
    }

    private void associateSessionDispatcher(ServletContext context) {
        context.setAttribute(SessionDispatcher.class.getName(), (Object)this);
    }

    private static SessionDispatcher lookupSessionDispatcher(ServletContext context) {
        return (SessionDispatcher)context.getAttribute(SessionDispatcher.class.getName());
    }

    private static SessionDispatcher lookupSessionDispatcher(Map applicationMap) {
        return (SessionDispatcher)applicationMap.get(SessionDispatcher.class.getName());
    }

    public static class Monitor
    implements Externalizable {
        private final String POSITIVE_SESSION_TIMEOUT = "positive_session_timeout";
        private Set contexts = new HashSet();
        private HttpSession session;
        private long lastAccess;

        private Monitor(HttpSession session) {
            this.session = session;
            this.lastAccess = session.getLastAccessedTime();
            session.setAttribute((class$com$icesoft$faces$webapp$http$servlet$SessionDispatcher$Monitor == null ? (class$com$icesoft$faces$webapp$http$servlet$SessionDispatcher$Monitor = SessionDispatcher.class$("com.icesoft.faces.webapp.http.servlet.SessionDispatcher$Monitor")) : class$com$icesoft$faces$webapp$http$servlet$SessionDispatcher$Monitor).getName(), (Object)this);
        }

        public static Monitor lookupSessionMonitor(HttpSession session) {
            return (Monitor)session.getAttribute((class$com$icesoft$faces$webapp$http$servlet$SessionDispatcher$Monitor == null ? (class$com$icesoft$faces$webapp$http$servlet$SessionDispatcher$Monitor = SessionDispatcher.class$("com.icesoft.faces.webapp.http.servlet.SessionDispatcher$Monitor")) : class$com$icesoft$faces$webapp$http$servlet$SessionDispatcher$Monitor).getName());
        }

        public void touchSession() {
            this.lastAccess = System.currentTimeMillis();
        }

        public Date expiresBy() {
            return new Date(this.lastAccess + (long)(this.session.getMaxInactiveInterval() * 1000));
        }

        public boolean isExpired() {
            long elapsedInterval = System.currentTimeMillis() - this.lastAccess;
            try {
                int maxInterval = this.session.getMaxInactiveInterval();
                Object o = this.session.getAttribute("positive_session_timeout");
                if (maxInterval > 0) {
                    if (o == null) {
                        this.session.setAttribute("positive_session_timeout", (Object)new Integer(maxInterval));
                    }
                } else if (o != null) {
                    maxInterval = (Integer)o;
                    this.session.setMaxInactiveInterval(maxInterval);
                }
                if (maxInterval < 0) {
                    return false;
                }
                return elapsedInterval + 15000L > (long)(maxInterval * 1000);
            }
            catch (Exception e) {
                return true;
            }
        }

        public void shutdown() {
            Iterator i = this.contexts.iterator();
            while (i.hasNext()) {
                ServletContext context = (ServletContext)i.next();
                SessionDispatcher.notifySessionShutdown(this.session, context);
            }
            try {
                this.session.invalidate();
            }
            catch (IllegalStateException e) {
                Log.info((Object)"Session already invalidated.");
            }
        }

        public void shutdownIfExpired() {
            if (this.isExpired()) {
                this.shutdown();
            }
        }

        public void addInSessionContext(ServletContext context) {
            this.contexts.add(context);
        }

        public void writeExternal(ObjectOutput out) throws IOException {
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        }

        public Monitor() {
        }
    }

    public static class Listener
    implements ServletContextListener,
    HttpSessionListener {
        private boolean run = true;

        public void contextInitialized(ServletContextEvent servletContextEvent) {
            try {
                Thread monitor = new Thread("Session Monitor"){

                    public void run() {
                        while (Listener.this.run) {
                            try {
                                Iterator iterator = new ArrayList(SessionMonitors.values()).iterator();
                                while (iterator.hasNext()) {
                                    Monitor sessionMonitor = (Monitor)iterator.next();
                                    sessionMonitor.shutdownIfExpired();
                                    ThreadLocalUtility.checkThreadLocals(2);
                                }
                                Thread.sleep(10000L);
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                    }
                };
                monitor.setDaemon(true);
                monitor.start();
            }
            catch (Exception e) {
                Log.error((Object)"Unable to initialize Session Monitor ", (Throwable)e);
            }
        }

        public void contextDestroyed(ServletContextEvent servletContextEvent) {
            this.run = false;
        }

        public void sessionCreated(HttpSessionEvent event) {
        }

        public void sessionDestroyed(HttpSessionEvent event) {
            HttpSession session = event.getSession();
            SessionDispatcher.notifySessionShutdown(session, session.getServletContext());
        }
    }
}

