/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.context;

import com.icesoft.faces.context.Resource;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;

public class ByteArrayResource
implements Resource,
Serializable {
    private final Date lastModified;
    private byte[] content;

    public ByteArrayResource(byte[] content) {
        this.content = content;
        this.lastModified = new Date();
    }

    public String calculateDigest() {
        return String.valueOf(this.content);
    }

    public Date lastModified() {
        return this.lastModified;
    }

    public InputStream open() throws IOException {
        return new ByteArrayInputStream(this.content);
    }

    public void withOptions(Resource.Options options) throws IOException {
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ByteArrayResource)) {
            return false;
        }
        ByteArrayResource bar = (ByteArrayResource)obj;
        if (!this.lastModified.equals(bar.lastModified)) {
            return false;
        }
        return Arrays.equals(this.content, bar.content);
    }
}

