/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.mex.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.impl.OMNamespaceImpl;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.dataretrieval.OutputForm;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.mex.MexException;
import org.apache.axis2.mex.om.Metadata;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MexUtil {
    private static final Log log = LogFactory.getLog(MexUtil.class);

    public static int getSOAPVersion(SOAPEnvelope envelope) throws MexException {
        String namespaceName = envelope.getNamespace().getNamespaceURI();
        if (namespaceName.equals("http://schemas.xmlsoap.org/soap/envelope/")) {
            return 1;
        }
        if (namespaceName.equals("http://www.w3.org/2003/05/soap-envelope")) {
            return 2;
        }
        throw new MexException("Unknown SOAP version");
    }

    public static SOAPFactory getSOAPFactory(String soapNameSpaceURI) throws MexException {
        if (soapNameSpaceURI.equals("http://schemas.xmlsoap.org/soap/envelope/")) {
            return OMAbstractFactory.getSOAP11Factory();
        }
        if (soapNameSpaceURI.equals("http://www.w3.org/2003/05/soap-envelope")) {
            return OMAbstractFactory.getSOAP12Factory();
        }
        throw new MexException("Unknown SOAP soapNameSpaceURI");
    }

    public static SOAPFactory getSOAPFactory(int SOAPVersion2) {
        if (SOAPVersion2 == 1) {
            return OMAbstractFactory.getSOAP11Factory();
        }
        return OMAbstractFactory.getSOAP12Factory();
    }

    public static OutputForm[] allSupportedOutputForms() {
        OutputForm[] outputforms = new OutputForm[]{OutputForm.INLINE_FORM, OutputForm.LOCATION_FORM, OutputForm.REFERENCE_FORM};
        return outputforms;
    }

    public static Metadata fromEPR(EndpointReference epr) throws MexException {
        ArrayList eprMetdata = epr.getMetaData();
        OMElement mexElement = null;
        Metadata metadata = null;
        if (eprMetdata != null) {
            mexElement = (OMElement)eprMetdata.get(0);
        } else {
            ArrayList refParm = epr.getExtensibleElements();
            if (refParm != null) {
                for (int i = 0; i < refParm.size(); ++i) {
                    OMElement elem = (OMElement)refParm.get(i);
                    if (!elem.getLocalName().equals("Metadata")) continue;
                    mexElement = elem;
                    break;
                }
            }
        }
        if (mexElement != null) {
            metadata = MexUtil.fromOM(mexElement, "http://schemas.xmlsoap.org/ws/2004/09/mex");
        }
        return metadata;
    }

    public static OMNamespaceImpl getAddressingNameSpace(OMElement toAddress) throws MexException {
        OMFactory factory = OMAbstractFactory.getOMFactory();
        OMNamespaceImpl wsa = null;
        try {
            String prefix = toAddress.getNamespace().getPrefix();
            String nsURI = toAddress.getNamespace().getNamespaceURI();
            wsa = (OMNamespaceImpl)factory.createOMNamespace(nsURI, prefix);
        }
        catch (Exception e) {
            throw new MexException(e);
        }
        return wsa;
    }

    public static Metadata fromOM(OMElement omElement) throws MexException {
        Metadata metadata = MexUtil.fromOM(omElement, "http://schemas.xmlsoap.org/ws/2004/09/mex");
        return metadata;
    }

    public static Metadata fromOM(OMElement omElement, String mexNamespaceValue) throws MexException {
        SOAPFactory factory = MexUtil.getSOAPFactory("http://www.w3.org/2003/05/soap-envelope");
        Metadata metadata = new Metadata((OMFactory)factory, mexNamespaceValue);
        metadata = metadata.fromOM(omElement);
        return metadata;
    }

    public static boolean isMexDisabled(Parameter serviceConfigMEXParm) {
        OMElement mexConfig;
        String disable;
        boolean disabled = false;
        if (serviceConfigMEXParm != null && (disable = (mexConfig = serviceConfigMEXParm.getParameterElement()).getAttributeValue(new QName("enable"))) != null && disable.equals("false")) {
            disabled = true;
        }
        return disabled;
    }

    public static OutputForm[] determineOutputForm(String dialect, Parameter axisConfigMEXParm, Parameter serviceConfigMEXParm) {
        if (axisConfigMEXParm == null && serviceConfigMEXParm == null) {
            return MexUtil.allSupportedOutputForms();
        }
        OutputForm[] outputform = new OutputForm[]{};
        outputform = MexUtil.determineOutputForm(dialect, serviceConfigMEXParm);
        if (outputform.length == 0) {
            outputform = MexUtil.determineOutputForm(dialect, axisConfigMEXParm);
        }
        if (outputform.length == 0) {
            log.debug((Object)"No outputform configured, use default output forms");
            outputform = MexUtil.allSupportedOutputForms();
        }
        return outputform;
    }

    private static OutputForm[] determineOutputForm(String dialect, Parameter mexParm) {
        OutputForm[] forms = new OutputForm[]{};
        if (mexParm == null) {
            return forms;
        }
        OMElement mexConfig = mexParm.getParameterElement();
        Iterator ite = mexConfig.getChildrenWithName(new QName("outputform"));
        String dialectForm_configured = null;
        String serviceForm_configured = null;
        while (ite.hasNext()) {
            OMElement elem = (OMElement)ite.next();
            String form_value = elem.getAttributeValue(new QName("forms"));
            String dialect_value = elem.getAttributeValue(new QName("dialect"));
            if (dialect_value == null) {
                serviceForm_configured = form_value;
                continue;
            }
            if (dialect_value == null || !dialect_value.equals(dialect)) continue;
            dialectForm_configured = form_value;
        }
        if (dialectForm_configured != null) {
            forms = MexUtil.parseForms(dialectForm_configured);
        } else if (serviceForm_configured != null) {
            forms = MexUtil.parseForms(serviceForm_configured);
        }
        return forms;
    }

    private static OutputForm[] parseForms(String form_values) {
        ArrayList<OutputForm> forms = new ArrayList<OutputForm>();
        StringTokenizer st = new StringTokenizer(form_values, ",");
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.equals("inline")) {
                forms.add(OutputForm.INLINE_FORM);
                continue;
            }
            if (token.equals("location")) {
                forms.add(OutputForm.LOCATION_FORM);
                continue;
            }
            if (token.equals("reference")) {
                forms.add(OutputForm.REFERENCE_FORM);
                continue;
            }
            log.debug((Object)("Invalid form configured, " + form_values));
        }
        return forms.toArray(new OutputForm[0]);
    }
}

