/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.corba.idl.values;

import java.io.Serializable;
import org.apache.axis2.corba.idl.types.ArrayType;
import org.apache.axis2.corba.idl.types.CompositeDataType;
import org.apache.axis2.corba.idl.types.DataType;
import org.apache.axis2.corba.idl.types.EnumType;
import org.apache.axis2.corba.idl.types.ExceptionType;
import org.apache.axis2.corba.idl.types.Member;
import org.apache.axis2.corba.idl.types.SequenceType;
import org.apache.axis2.corba.idl.types.Struct;
import org.apache.axis2.corba.idl.types.Typedef;
import org.apache.axis2.corba.idl.types.UnionType;
import org.apache.axis2.corba.idl.values.AliasValue;
import org.apache.axis2.corba.idl.values.ArrayValue;
import org.apache.axis2.corba.idl.values.EnumValue;
import org.apache.axis2.corba.idl.values.ExceptionValue;
import org.apache.axis2.corba.idl.values.SequenceValue;
import org.apache.axis2.corba.idl.values.StructValue;
import org.apache.axis2.corba.idl.values.UnionValue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.omg.CORBA.Any;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA_2_3.portable.InputStream;
import org.omg.CORBA_2_3.portable.OutputStream;

public abstract class AbstractValue {
    protected Object[] memberValues;
    protected CompositeDataType dataType;
    private static final Log log = LogFactory.getLog(AbstractValue.class);

    protected AbstractValue(CompositeDataType dataType) {
        this.dataType = dataType;
    }

    public Member[] getMembers() {
        return this.dataType.getMembers();
    }

    public void setMemberValues(Object[] memberValues) {
        this.memberValues = memberValues;
    }

    public Object[] getMemberValues() {
        return this.memberValues;
    }

    public TypeCode getTypeCode() {
        return this.dataType.getTypeCode();
    }

    protected void write(Object value, DataType dataType, OutputStream outputStream) {
        TCKind kind = dataType.getTypeCode().kind();
        switch (kind.value()) {
            case 3: {
                outputStream.write_long(((Integer)value).intValue());
                break;
            }
            case 5: {
                outputStream.write_ulong(((Integer)value).intValue());
                break;
            }
            case 23: {
                outputStream.write_longlong(((Long)value).longValue());
                break;
            }
            case 24: {
                outputStream.write_ulonglong(((Long)value).longValue());
                break;
            }
            case 2: {
                outputStream.write_short(((Short)value).shortValue());
                break;
            }
            case 4: {
                outputStream.write_ushort(((Short)value).shortValue());
                break;
            }
            case 6: {
                outputStream.write_float(((Float)value).floatValue());
                break;
            }
            case 7: {
                outputStream.write_double((double)((Double)value).floatValue());
                break;
            }
            case 9: {
                outputStream.write_char(((Character)value).charValue());
                break;
            }
            case 26: {
                outputStream.write_wchar(((Character)value).charValue());
                break;
            }
            case 8: {
                outputStream.write_boolean(((Boolean)value).booleanValue());
                break;
            }
            case 10: {
                outputStream.write_octet(((Byte)value).byteValue());
                break;
            }
            case 18: {
                outputStream.write_string((String)value);
                break;
            }
            case 27: {
                outputStream.write_wstring((String)value);
                break;
            }
            case 11: {
                outputStream.write_any((Any)value);
                break;
            }
            case 29: {
                outputStream.write_value((Serializable)value);
                break;
            }
            case 15: {
                ((StructValue)value).write(outputStream);
                break;
            }
            case 17: {
                ((EnumValue)value).write(outputStream);
                break;
            }
            case 16: {
                ((UnionValue)value).write(outputStream);
                break;
            }
            case 21: {
                ((AliasValue)value).write(outputStream);
                break;
            }
            case 19: {
                ((SequenceValue)value).write(outputStream);
                break;
            }
            case 20: {
                ((ArrayValue)value).write(outputStream);
                break;
            }
            default: {
                log.error((Object)"ERROR! Invalid dataType");
            }
        }
    }

    protected Object read(DataType dataType, InputStream inputStream) {
        TCKind kind = dataType.getTypeCode().kind();
        Object ret = null;
        switch (kind.value()) {
            case 3: {
                ret = new Integer(inputStream.read_long());
                break;
            }
            case 5: {
                ret = new Integer(inputStream.read_ulong());
                break;
            }
            case 23: {
                ret = new Long(inputStream.read_longlong());
                break;
            }
            case 24: {
                ret = new Long(inputStream.read_ulonglong());
                break;
            }
            case 2: {
                ret = new Short(inputStream.read_short());
                break;
            }
            case 4: {
                ret = new Short(inputStream.read_ushort());
                break;
            }
            case 6: {
                ret = new Float(inputStream.read_float());
                break;
            }
            case 7: {
                ret = new Double(inputStream.read_double());
                break;
            }
            case 9: {
                ret = new Character(inputStream.read_char());
                break;
            }
            case 26: {
                ret = new Character(inputStream.read_wchar());
                break;
            }
            case 8: {
                ret = inputStream.read_boolean();
                break;
            }
            case 10: {
                ret = new Byte(inputStream.read_octet());
                break;
            }
            case 18: {
                ret = inputStream.read_string();
                break;
            }
            case 27: {
                ret = inputStream.read_wstring();
                break;
            }
            case 11: {
                ret = inputStream.read_any();
                break;
            }
            case 29: {
                ret = inputStream.read_value();
                break;
            }
            case 15: {
                StructValue structValue = new StructValue((Struct)dataType);
                structValue.read(inputStream);
                ret = structValue;
                break;
            }
            case 17: {
                EnumValue enumValue = new EnumValue((EnumType)dataType);
                enumValue.read(inputStream);
                ret = enumValue;
                break;
            }
            case 16: {
                UnionValue unionValue = new UnionValue((UnionType)dataType);
                unionValue.read(inputStream);
                ret = unionValue;
                break;
            }
            case 21: {
                AliasValue aliasValue = new AliasValue((Typedef)dataType);
                aliasValue.read(inputStream);
                ret = aliasValue;
                break;
            }
            case 19: {
                SequenceValue sequenceValue = new SequenceValue((SequenceType)dataType);
                sequenceValue.read(inputStream);
                ret = sequenceValue;
                break;
            }
            case 20: {
                ArrayValue arrayValue = new ArrayValue((ArrayType)dataType);
                arrayValue.read(inputStream);
                ret = arrayValue;
                break;
            }
            case 22: {
                ExceptionValue exValue = new ExceptionValue((ExceptionType)dataType);
                exValue.read(inputStream);
                ret = exValue;
                break;
            }
            default: {
                log.error((Object)"ERROR! Invalid dataType");
            }
        }
        return ret;
    }

    public String toString() {
        Member[] members = this.getMembers();
        String ret = "CompositeDataType name: " + this.dataType.getModule() + this.dataType.getName() + '\n';
        for (int i = 0; i < members.length; ++i) {
            Object value = this.memberValues[i];
            ret = ret + '\t' + members[i].getName() + ": " + value + '\n';
        }
        return ret;
    }
}

