/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.ui;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.acegisecurity.AccessDeniedException;
import org.acegisecurity.AcegiSecurityException;
import org.acegisecurity.AuthenticationException;
import org.acegisecurity.AuthenticationTrustResolver;
import org.acegisecurity.AuthenticationTrustResolverImpl;
import org.acegisecurity.InsufficientAuthenticationException;
import org.acegisecurity.context.SecurityContextHolder;
import org.acegisecurity.ui.AccessDeniedHandler;
import org.acegisecurity.ui.AccessDeniedHandlerImpl;
import org.acegisecurity.ui.AuthenticationEntryPoint;
import org.acegisecurity.ui.savedrequest.SavedRequest;
import org.acegisecurity.util.PortResolver;
import org.acegisecurity.util.PortResolverImpl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class ExceptionTranslationFilter
implements Filter,
InitializingBean {
    private static final Log logger = LogFactory.getLog((Class)(class$org$acegisecurity$ui$ExceptionTranslationFilter == null ? (class$org$acegisecurity$ui$ExceptionTranslationFilter = ExceptionTranslationFilter.class$("org.acegisecurity.ui.ExceptionTranslationFilter")) : class$org$acegisecurity$ui$ExceptionTranslationFilter));
    private AccessDeniedHandler accessDeniedHandler = new AccessDeniedHandlerImpl();
    private AuthenticationEntryPoint authenticationEntryPoint;
    private AuthenticationTrustResolver authenticationTrustResolver = new AuthenticationTrustResolverImpl();
    private PortResolver portResolver = new PortResolverImpl();
    private boolean createSessionAllowed = true;
    static /* synthetic */ Class class$org$acegisecurity$ui$ExceptionTranslationFilter;

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.authenticationEntryPoint, (String)"authenticationEntryPoint must be specified");
        Assert.notNull((Object)this.portResolver, (String)"portResolver must be specified");
        Assert.notNull((Object)this.authenticationTrustResolver, (String)"authenticationTrustResolver must be specified");
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!(request instanceof HttpServletRequest)) {
            throw new ServletException("HttpServletRequest required");
        }
        if (!(response instanceof HttpServletResponse)) {
            throw new ServletException("HttpServletResponse required");
        }
        try {
            chain.doFilter(request, response);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Chain processed normally");
            }
        }
        catch (AuthenticationException ex) {
            this.handleException(request, response, chain, ex);
        }
        catch (AccessDeniedException ex) {
            this.handleException(request, response, chain, ex);
        }
        catch (ServletException ex) {
            if (ex.getRootCause() instanceof AuthenticationException || ex.getRootCause() instanceof AccessDeniedException) {
                this.handleException(request, response, chain, (AcegiSecurityException)((Object)ex.getRootCause()));
            }
            throw ex;
        }
        catch (IOException ex) {
            throw ex;
        }
    }

    public AuthenticationEntryPoint getAuthenticationEntryPoint() {
        return this.authenticationEntryPoint;
    }

    public AuthenticationTrustResolver getAuthenticationTrustResolver() {
        return this.authenticationTrustResolver;
    }

    public PortResolver getPortResolver() {
        return this.portResolver;
    }

    private void handleException(ServletRequest request, ServletResponse response, FilterChain chain, AcegiSecurityException exception) throws IOException, ServletException {
        if (exception instanceof AuthenticationException) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Authentication exception occurred; redirecting to authentication entry point", (Throwable)((Object)exception));
            }
            this.sendStartAuthentication(request, response, chain, (AuthenticationException)exception);
        } else if (exception instanceof AccessDeniedException) {
            if (this.authenticationTrustResolver.isAnonymous(SecurityContextHolder.getContext().getAuthentication())) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Access is denied (user is anonymous); redirecting to authentication entry point", (Throwable)((Object)exception));
                }
                this.sendStartAuthentication(request, response, chain, new InsufficientAuthenticationException("Full authentication is required to access this resource"));
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Access is denied (user is not anonymous); delegating to AccessDeniedHandler", (Throwable)((Object)exception));
                }
                this.accessDeniedHandler.handle(request, response, (AccessDeniedException)exception);
            }
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public boolean isCreateSessionAllowed() {
        return this.createSessionAllowed;
    }

    protected void sendStartAuthentication(ServletRequest request, ServletResponse response, FilterChain chain, AuthenticationException reason) throws ServletException, IOException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        SavedRequest savedRequest = new SavedRequest(httpRequest, this.portResolver);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Authentication entry point being called; SavedRequest added to Session: " + savedRequest));
        }
        if (this.createSessionAllowed) {
            httpRequest.getSession().setAttribute("ACEGI_SAVED_REQUEST_KEY", (Object)savedRequest);
        }
        SecurityContextHolder.getContext().setAuthentication(null);
        this.authenticationEntryPoint.commence((ServletRequest)httpRequest, (ServletResponse)((HttpServletResponse)response), reason);
    }

    public void setAccessDeniedHandler(AccessDeniedHandler accessDeniedHandler) {
        Assert.notNull((Object)accessDeniedHandler, (String)"AccessDeniedHandler required");
        this.accessDeniedHandler = accessDeniedHandler;
    }

    public void setAuthenticationEntryPoint(AuthenticationEntryPoint authenticationEntryPoint) {
        this.authenticationEntryPoint = authenticationEntryPoint;
    }

    public void setAuthenticationTrustResolver(AuthenticationTrustResolver authenticationTrustResolver) {
        this.authenticationTrustResolver = authenticationTrustResolver;
    }

    public void setCreateSessionAllowed(boolean createSessionAllowed) {
        this.createSessionAllowed = createSessionAllowed;
    }

    public void setPortResolver(PortResolver portResolver) {
        this.portResolver = portResolver;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

