/*
 * Decompiled with CFR 0.152.
 */
package org.apache.woden.internal.wsdl20.extensions.soap;

import java.net.URI;
import org.apache.woden.ErrorReporter;
import org.apache.woden.wsdl20.Binding;
import org.apache.woden.wsdl20.NestedComponent;
import org.apache.woden.wsdl20.WSDLComponent;
import org.apache.woden.wsdl20.extensions.BaseComponentExtensionContext;
import org.apache.woden.wsdl20.extensions.ExtensionElement;
import org.apache.woden.wsdl20.extensions.ExtensionProperty;
import org.apache.woden.wsdl20.extensions.http.HTTPConstants;
import org.apache.woden.wsdl20.extensions.http.HTTPLocation;
import org.apache.woden.wsdl20.extensions.soap.SOAPBindingExtensions;
import org.apache.woden.wsdl20.extensions.soap.SOAPBindingOperationExtensions;
import org.apache.woden.wsdl20.extensions.soap.SOAPConstants;
import org.apache.woden.wsdl20.extensions.soap.SOAPModule;
import org.apache.woden.wsdl20.xml.WSDLElement;
import org.apache.woden.xml.StringAttr;
import org.apache.woden.xml.URIAttr;

public class SOAPBindingOperationExtensionsImpl
extends BaseComponentExtensionContext
implements SOAPBindingOperationExtensions {
    public SOAPBindingOperationExtensionsImpl(WSDLComponent parent, URI extNamespace, ErrorReporter errReporter) {
        super(parent, extNamespace, errReporter);
    }

    public ExtensionProperty[] getProperties() {
        return new ExtensionProperty[]{this.getProperty("soap mep"), this.getProperty("soap action"), this.getProperty("soap modules")};
    }

    public ExtensionProperty getProperty(String propertyName) {
        if ("soap mep".equals(propertyName)) {
            return this.newExtensionProperty("soap mep", this.getSoapMep());
        }
        if ("soap action".equals(propertyName)) {
            return this.newExtensionProperty("soap action", this.getSoapAction());
        }
        if ("soap modules".equals(propertyName)) {
            return this.newExtensionProperty("soap modules", this.getSoapModules());
        }
        return null;
    }

    public URI getSoapMep() {
        URIAttr mep = (URIAttr)((WSDLElement)this.getParent()).getExtensionAttribute(SOAPConstants.Q_ATTR_SOAP_MEP);
        return mep != null ? mep.getURI() : null;
    }

    public URI getSoapAction() {
        URIAttr action = (URIAttr)((WSDLElement)this.getParent()).getExtensionAttribute(SOAPConstants.Q_ATTR_SOAP_ACTION);
        return action != null ? action.getURI() : null;
    }

    public SOAPModule[] getSoapModules() {
        ExtensionElement[] extEls = ((WSDLElement)this.getParent()).getExtensionElementsOfType(SOAPConstants.Q_ELEM_SOAP_MODULE);
        int len = extEls.length;
        SOAPModule[] soapMods = new SOAPModule[len];
        System.arraycopy(extEls, 0, soapMods, 0, len);
        return soapMods;
    }

    public HTTPLocation getHttpLocation() {
        Binding binding = (Binding)((NestedComponent)this.getParent()).getParent();
        SOAPBindingExtensions soapBindExt = (SOAPBindingExtensions)binding.getComponentExtensionContext(SOAPConstants.NS_URI_SOAP);
        String version = soapBindExt.getSoapVersion();
        URI protocol = soapBindExt.getSoapUnderlyingProtocol();
        if (protocol == null) {
            return null;
        }
        if ("1.2".equals(version) && protocol.equals(SOAPConstants.PROTOCOL_URI_SOAP12_HTTP) || "1.1".equals(version) && protocol.equals(SOAPConstants.PROTOCOL_URI_SOAP11_HTTP)) {
            StringAttr httpLoc = (StringAttr)((WSDLElement)this.getParent()).getExtensionAttribute(HTTPConstants.Q_ATTR_LOCATION);
            return httpLoc != null ? new HTTPLocation(httpLoc.getString()) : null;
        }
        return null;
    }

    public String getHttpQueryParameterSeparator() {
        Binding binding = (Binding)((NestedComponent)this.getParent()).getParent();
        SOAPBindingExtensions soapBindExt = (SOAPBindingExtensions)binding.getComponentExtensionContext(SOAPConstants.NS_URI_SOAP);
        String version = soapBindExt.getSoapVersion();
        URI protocol = soapBindExt.getSoapUnderlyingProtocol();
        if (protocol == null) {
            return null;
        }
        if ("1.2".equals(version) && protocol.equals(SOAPConstants.PROTOCOL_URI_SOAP12_HTTP) || "1.1".equals(version) && protocol.equals(SOAPConstants.PROTOCOL_URI_SOAP11_HTTP)) {
            StringAttr separator = (StringAttr)((WSDLElement)this.getParent()).getExtensionAttribute(HTTPConstants.Q_ATTR_QUERY_PARAMETER_SEPARATOR);
            return separator != null ? separator.getString() : null;
        }
        return null;
    }

    public String getHttpContentEncodingDefault() {
        Binding binding = (Binding)((NestedComponent)this.getParent()).getParent();
        SOAPBindingExtensions soapBindExt = (SOAPBindingExtensions)binding.getComponentExtensionContext(SOAPConstants.NS_URI_SOAP);
        String version = soapBindExt.getSoapVersion();
        URI protocol = soapBindExt.getSoapUnderlyingProtocol();
        if (protocol == null) {
            return null;
        }
        if ("1.2".equals(version) && protocol.equals(SOAPConstants.PROTOCOL_URI_SOAP12_HTTP) || "1.1".equals(version) && protocol.equals(SOAPConstants.PROTOCOL_URI_SOAP11_HTTP)) {
            StringAttr ceDef = (StringAttr)((WSDLElement)this.getParent()).getExtensionAttribute(HTTPConstants.Q_ATTR_CONTENT_ENCODING_DEFAULT);
            return ceDef != null ? ceDef.getString() : null;
        }
        return null;
    }
}

