/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.webapp.xmlhttp;

import com.icesoft.faces.context.BridgeExternalContext;
import com.icesoft.faces.context.BridgeFacesContext;
import com.icesoft.faces.context.View;
import com.icesoft.faces.context.ViewListener;
import com.icesoft.faces.util.CoreUtils;
import com.icesoft.faces.webapp.http.common.Configuration;
import com.icesoft.faces.webapp.http.core.SessionExpiredException;
import com.icesoft.faces.webapp.parser.ImplementationUtil;
import com.icesoft.faces.webapp.xmlhttp.FatalRenderingException;
import com.icesoft.faces.webapp.xmlhttp.RenderingException;
import com.icesoft.faces.webapp.xmlhttp.TransientRenderingException;
import com.icesoft.util.SeamUtilities;
import edu.emory.mathcs.backport.java.util.concurrent.ExecutorService;
import edu.emory.mathcs.backport.java.util.concurrent.Executors;
import edu.emory.mathcs.backport.java.util.concurrent.ThreadFactory;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import javax.faces.FactoryFinder;
import javax.faces.context.FacesContext;
import javax.faces.lifecycle.Lifecycle;
import javax.faces.lifecycle.LifecycleFactory;
import javax.portlet.PortletSession;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PersistentFacesState
implements Serializable {
    private static final Log log = LogFactory.getLog((Class)PersistentFacesState.class);
    private static final ExecutorService executorService = Executors.newSingleThreadExecutor((ThreadFactory)new DaemonThreadFactory());
    private static final InheritableThreadLocal localInstance = new InheritableThreadLocal();
    private final ClassLoader renderableClassLoader = Thread.currentThread().getContextClassLoader();
    private final Lifecycle lifecycle;
    private final boolean synchronousMode;
    private final Collection viewListeners;
    private View view;
    private boolean disposed;
    private String stateRestorationId;

    public PersistentFacesState(View view, Collection viewListeners, Configuration configuration) {
        LifecycleFactory factory = (LifecycleFactory)FactoryFinder.getFactory((String)"javax.faces.lifecycle.LifecycleFactory");
        this.lifecycle = factory.getLifecycle("DEFAULT");
        this.view = view;
        this.viewListeners = viewListeners;
        this.synchronousMode = configuration.getAttributeAsBoolean("synchronousUpdate", false);
        this.setCurrentInstance();
    }

    public void dispose() {
        this.disposed = true;
    }

    public void setCurrentInstance() {
        localInstance.set(this);
    }

    public static boolean isThreadLocalNull() {
        return localInstance.get() == null;
    }

    public static PersistentFacesState getInstance() {
        return (PersistentFacesState)localInstance.get();
    }

    public static PersistentFacesState getInstance(Map sessionMap) {
        return PersistentFacesState.getInstance();
    }

    public FacesContext getFacesContext() {
        return this.view.getFacesContext();
    }

    public boolean isSynchronousMode() {
        return this.synchronousMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render() throws RenderingException {
        this.failIfDisposed();
        this.warnIfSynchronous();
        BridgeFacesContext facesContext = this.view.getFacesContext();
        try {
            this.view.acquireLifecycleLock();
            this.view.installThreadLocals();
            facesContext.setFocusId("");
            this.lifecycle.render((FacesContext)facesContext);
        }
        catch (Exception e) {
            String viewID = "Unknown View";
            try {
                viewID = facesContext.getViewRoot().getViewId();
            }
            catch (NullPointerException npe) {
                // empty catch block
            }
            log.error((Object)("Exception occured during execute push on " + viewID), (Throwable)e);
            this.throwRenderingException(e);
        }
        finally {
            facesContext.release();
            this.release();
            this.view.releaseLifecycleLock();
        }
    }

    public void renderLater() {
        this.warnIfSynchronous();
        executorService.execute((Runnable)new RenderRunner());
    }

    public void renderLater(long miliseconds) {
        this.warnIfSynchronous();
        executorService.execute((Runnable)new RenderRunner(miliseconds));
    }

    public void renderLater(Runnable setup, boolean warnSync) {
        if (warnSync) {
            this.warnIfSynchronous();
        }
        executorService.execute((Runnable)new RenderRunner(setup));
    }

    public void execute() throws RenderingException {
        this.failIfDisposed();
        BridgeFacesContext facesContext = null;
        try {
            this.view.acquireLifecycleLock();
            this.view.installThreadLocals();
            facesContext = this.view.getFacesContext();
            Map requestParameterMap = facesContext.getExternalContext().getRequestParameterMap();
            requestParameterMap.clear();
            if (SeamUtilities.isSeamEnvironment()) {
                ((BridgeExternalContext)facesContext.getExternalContext()).removeSeamAttributes();
            }
            String postback = ImplementationUtil.isJSFStateSaving() && this.stateRestorationId != null ? this.stateRestorationId : "not reload";
            facesContext.getExternalContext().getRequestParameterMap().put(BridgeExternalContext.PostBackKey, postback);
            this.lifecycle.execute((FacesContext)facesContext);
        }
        catch (Exception e) {
            this.release();
            this.view.releaseLifecycleLock();
            String viewID = "Unknown View";
            try {
                viewID = facesContext.getViewRoot().getViewId();
            }
            catch (NullPointerException npe) {
                // empty catch block
            }
            log.error((Object)("Exception occured during execute push on " + viewID), (Throwable)e);
            this.throwRenderingException(e);
        }
    }

    public void executeAndRender() throws RenderingException {
        this.view.acquireLifecycleLock();
        this.view.getFacesContext().injectBundles();
        CoreUtils.addAuxiliaryContexts(this.view.getFacesContext());
        this.execute();
        this.render();
    }

    public void setupAndExecuteAndRender() throws RenderingException {
        this.view.acquireLifecycleLock();
        this.installContextClassLoader();
        if (SeamUtilities.isSeamEnvironment()) {
            this.testSession();
        }
        this.executeAndRender();
    }

    public void redirectTo(final String uri) {
        this.warnIfSynchronous();
        executorService.execute(new Runnable(){

            public void run() {
                try {
                    PersistentFacesState.this.view.acquireLifecycleLock();
                    PersistentFacesState.this.view.installThreadLocals();
                    PersistentFacesState.this.view.getFacesContext().getExternalContext().redirect(uri);
                }
                catch (Exception e) {
                    log.error((Object)"Exception during redirectTo ", (Throwable)e);
                    throw new RuntimeException(e);
                }
                finally {
                    PersistentFacesState.this.release();
                    PersistentFacesState.this.view.releaseLifecycleLock();
                }
            }
        });
    }

    public void navigateTo(String outcome) {
        this.warnIfSynchronous();
        try {
            boolean manageLifecycle;
            BridgeFacesContext facesContext = this.view.getFacesContext();
            FacesContext fc = FacesContext.getCurrentInstance();
            boolean bl = manageLifecycle = fc == null || fc.getViewRoot() == null;
            if (manageLifecycle) {
                this.execute();
            }
            facesContext.getApplication().getNavigationHandler().handleNavigation((FacesContext)facesContext, facesContext.getViewRoot().getViewId(), outcome);
            if (manageLifecycle) {
                this.render();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void release() {
        localInstance.set(null);
    }

    public void installContextClassLoader() {
        try {
            Thread.currentThread().setContextClassLoader(this.renderableClassLoader);
        }
        catch (SecurityException se) {
            log.debug((Object)"setting context class loader is not permitted", (Throwable)se);
        }
    }

    public void addViewListener(ViewListener listener) {
        if (!this.viewListeners.contains(listener)) {
            this.viewListeners.add(listener);
        }
    }

    public void acquireUploadLifecycleLock() {
        this.view.acquireLifecycleLock();
    }

    public void releaseUploadLifecycleLock() {
        this.view.releaseLifecycleLock();
    }

    public void setAllCurrentInstances() {
        this.view.installThreadLocals();
    }

    private void warnIfSynchronous() {
        if (this.synchronousMode) {
            log.warn((Object)"Running in 'synchronous mode'. The page updates were queued but not sent.");
        }
    }

    private void testSession() throws IllegalStateException {
        Object o = this.view.getFacesContext().getExternalContext().getSession(false);
        if (o != null) {
            if (o instanceof HttpSession) {
                HttpSession session = (HttpSession)o;
                session.getAttributeNames();
            } else if (o instanceof PortletSession) {
                PortletSession ps = (PortletSession)o;
                ps.getAttributeNames();
            }
        }
    }

    private void fatalRenderingException() throws FatalRenderingException {
        String message = "fatal render failure for " + this.view;
        log.debug((Object)message);
        throw new FatalRenderingException(message);
    }

    private void fatalRenderingException(Exception e) throws FatalRenderingException {
        String message = "fatal render failure for " + this.view;
        log.debug((Object)message, (Throwable)e);
        throw new FatalRenderingException(message, e);
    }

    private void transientRenderingException(Exception e) throws TransientRenderingException {
        String message = "transient render failure for " + this.view;
        log.debug((Object)message, (Throwable)e);
        throw new TransientRenderingException(message, e);
    }

    private void throwRenderingException(Exception e) throws FatalRenderingException, TransientRenderingException {
        Throwable throwable = e;
        while (throwable != null) {
            if (throwable instanceof IllegalStateException || throwable instanceof SessionExpiredException) {
                this.fatalRenderingException(e);
                continue;
            }
            throwable = throwable.getCause();
        }
        this.transientRenderingException(e);
    }

    private void failIfDisposed() throws FatalRenderingException {
        if (this.disposed) {
            this.release();
            this.view.releaseLifecycleLock();
            this.fatalRenderingException();
        }
    }

    public String getStateRestorationId() {
        return this.stateRestorationId;
    }

    public void setStateRestorationId(String stateRestorationId) {
        this.stateRestorationId = stateRestorationId;
    }

    private static class DaemonThreadFactory
    implements ThreadFactory {
        private ThreadFactory defaultThreadFactory = Executors.defaultThreadFactory();

        private DaemonThreadFactory() {
        }

        public Thread newThread(Runnable runnable) {
            Thread thread = this.defaultThreadFactory.newThread(runnable);
            thread.setDaemon(true);
            return thread;
        }
    }

    private class RenderRunner
    implements Runnable {
        private final long delay;
        private Runnable setup;

        public RenderRunner() {
            this.delay = 0L;
        }

        public RenderRunner(long miliseconds) {
            this.delay = miliseconds;
        }

        public RenderRunner(Runnable setup) {
            this.delay = 0L;
            this.setup = setup;
        }

        public void run() {
            try {
                Thread.sleep(this.delay);
                if (this.setup != null) {
                    this.setup.run();
                }
                PersistentFacesState.this.setupAndExecuteAndRender();
            }
            catch (RenderingException e) {
                log.debug((Object)"renderLater failed ", (Throwable)e);
            }
            catch (InterruptedException e) {
            }
            catch (IllegalStateException e) {
                log.debug((Object)"renderLater failed ", (Throwable)e);
            }
        }
    }
}

