'''
Directive Objects

Created on 30.06.2009

@author: hmueller
'''

PrettyNames = {}

#
# Type definitions
#
class Path(str):
    pass

class Time(str):
    pass

class Acl(str):
    pass

class Password(str):
    pass

class Res(str):
    pass
#
# The Resource Item
#

class Item(object):
    def __init__(self, name, default=None, type=None, required=False):
        self.name = name
        self.default = default
        if default:
            self.value = default
        else:
            self.value = None
        self.type = type
        self.required = required
        
    def __repr__(self):
        return "Item(%s, %s, %s, %s)" % (self.name,
                                         str(self.default),
                                         str(self.type),
                                         self.required)
                                        
    def __lt__(self, other):
        return self.name < other.name
    
    def __str__(self):
        if PrettyNames.has_key(self.name):
            return '%s = "%s"' % (self.prettyName(), str(self.value))
        else:
            return '%s = "%s" # Warning: No pretty name' % (
                                            self.name, str(self.value))
    def prettyName(self):
        return PrettyNames.get(self.name, self.name)