'''
Resource Objects
Created on 30.06.2009

@author: hmueller
'''

class Resource(object):
    DIRECTIVE=""

    def __init__(self, level=0):
        self.items = []
        self.comments = []
        self._recurselevel = level
    
    def __str__(self):
        s = "\n".join(self.comments) 
        s += self.DIRECTIVE + "{\n"
        for d in self.items:
            s += "  " + str(d) + "\n"
        s += "}\n"
        return s
    
    def add_comment(self, comment):
        if not comment.lstrip().startswith("#"):
            comment = "# " + comment
        self.comments.append(comment)
        
    def add_item(self, item):
        self.items.append(item)

class Director(Resource):
    DIRECTIVE="Director"
    pass

class Job(Resource):
    DIRECTIVE="Job"

class JobDefs(Resource):
    DIRECTIVE="JobDefs"

class Schedule(Resource):
    DIRECTIVE="Schedule"

class FileSet(Resource):
    DIRECTIVE="FileSet"

class Client(Resource):
    DIRECTIVE="Client"

class Storage(Resource):
    DIRECTIVE="Storage"

class Pool(Resource):
    DIRECTIVE="Pool"

class Catalog(Resource):
   # ITEMS_DIRD = cdef.dird_cat_items
    DIRECTIVE="Catalog" 

class Messages(Resource):
    DIRECTIVE="Messages"

class Console(Resource):
    DIRECTIVE="Console"

class Counter(Resource):
    DIRECTIVE="Counter"

class Device(Resource):
    DIRECTIVE="Device"

class Autochanger(Resource):
    DIRECTIVE="Autochanger"

__cls = locals().copy()

directives = [v.DIRECTIVE for k,v in __cls.iteritems() 
              if k != "Resource" and getattr(v, "DIRECTIVE", None)]
