/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.webapp.http.servlet;

import com.icesoft.faces.webapp.http.common.ResponseHandler;
import com.icesoft.faces.webapp.http.common.Server;
import com.icesoft.faces.webapp.http.servlet.PseudoServlet;
import com.icesoft.faces.webapp.http.servlet.ServletRequestResponse;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mortbay.util.ajax.Continuation;
import org.mortbay.util.ajax.ContinuationSupport;

public class JettyAdaptingServlet
implements PseudoServlet {
    private Map requests = new HashMap();
    private Server server;

    public JettyAdaptingServlet(Server server) {
        this.server = server;
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (this.requests.containsKey(request)) {
            ResponseHandler handler = (ResponseHandler)this.requests.remove(request);
            handler.respond(new ServletRequestResponse(request, response));
        } else {
            ContinuationRequestResponse requestResponse = new ContinuationRequestResponse(request, response);
            this.server.service(requestResponse);
            requestResponse.captureContinuation();
        }
    }

    public void shutdown() {
        this.server.shutdown();
    }

    private class ContinuationRequestResponse
    extends ServletRequestResponse {
        private boolean captureContinuation;
        private Continuation continuation;

        public ContinuationRequestResponse(HttpServletRequest request, HttpServletResponse response) throws Exception {
            super(request, response);
            this.captureContinuation = true;
        }

        public synchronized void respondWith(ResponseHandler handler) throws Exception {
            if (this.continuation == null) {
                this.captureContinuation = false;
                super.respondWith(handler);
            } else {
                JettyAdaptingServlet.this.requests.put(this.request, handler);
                this.continuation.resume();
            }
        }

        public synchronized void captureContinuation() {
            if (this.captureContinuation) {
                this.continuation = ContinuationSupport.getContinuation((HttpServletRequest)this.request, (Object)this);
                this.continuation.suspend((long)(this.request.getSession().getMaxInactiveInterval() * 1000));
            }
        }
    }
}

