/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.async.render;

import com.icesoft.faces.async.render.RejectionHandler;
import com.icesoft.faces.async.render.RenderThreadFactory;
import com.icesoft.faces.async.render.Renderable;
import com.icesoft.faces.async.render.RunnableRender;
import com.icesoft.faces.async.render.SingleEntryQueue;
import com.icesoft.faces.webapp.http.common.Configuration;
import edu.emory.mathcs.backport.java.util.concurrent.BlockingQueue;
import edu.emory.mathcs.backport.java.util.concurrent.RejectedExecutionHandler;
import edu.emory.mathcs.backport.java.util.concurrent.ScheduledThreadPoolExecutor;
import edu.emory.mathcs.backport.java.util.concurrent.ThreadFactory;
import edu.emory.mathcs.backport.java.util.concurrent.ThreadPoolExecutor;
import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RenderHub {
    private static Log log = LogFactory.getLog((Class)RenderHub.class);
    private ThreadPoolExecutor renderService;
    private int corePoolSize;
    private int maxPoolSize;
    private long keepAliveTime;
    private int renderQueueCapacity;
    private ScheduledThreadPoolExecutor scheduledService;
    private int schedulePoolSize = 5;
    private RejectionHandler rejectionHandler;
    private RenderThreadFactory threadFactory;

    public RenderHub(Configuration configuration) {
        this.corePoolSize = configuration.getAttributeAsInteger("corePoolSize", 10);
        this.maxPoolSize = configuration.getAttributeAsInteger("maxPoolSize", 15);
        this.keepAliveTime = configuration.getAttributeAsLong("keepAliveTime", 300000L);
        this.renderQueueCapacity = configuration.getAttributeAsInteger("renderQueueCapacity", 1000);
        this.rejectionHandler = new RejectionHandler();
        this.threadFactory = new RenderThreadFactory();
    }

    public int getCorePoolSize() {
        return this.corePoolSize;
    }

    public void setCorePoolSize(int corePoolSize) {
        this.corePoolSize = corePoolSize;
        this.resetCoreService();
        this.resetScheduledService();
    }

    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public void setMaxPoolSize(int maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
        this.resetCoreService();
    }

    public long getKeepAliveTime() {
        return this.keepAliveTime;
    }

    public void setKeepAliveTime(long keepAliveTime) {
        this.keepAliveTime = keepAliveTime;
        this.resetCoreService();
    }

    public int getRenderQueueCapacity() {
        return this.renderQueueCapacity;
    }

    public void setRenderQueueCapacity(int renderQueueCapacity) {
        this.renderQueueCapacity = renderQueueCapacity;
        this.resetCoreService();
    }

    public void requestRender(Renderable renderable) {
        if (this.renderService == null) {
            this.createCoreService();
        }
        this.renderService.execute((Runnable)new RunnableRender(renderable));
    }

    private synchronized void createCoreService() {
        SingleEntryQueue queue = new SingleEntryQueue(this.renderQueueCapacity);
        this.renderService = new ThreadPoolExecutor(this.corePoolSize, this.maxPoolSize, this.keepAliveTime, TimeUnit.MILLISECONDS, (BlockingQueue)queue, (ThreadFactory)this.threadFactory, (RejectedExecutionHandler)this.rejectionHandler);
        if (log.isInfoEnabled()) {
            log.info((Object)("core render service created:\n  core pool size : " + this.corePoolSize + "\n  max pool size  : " + this.maxPoolSize + "\n  keep alive time: " + this.keepAliveTime));
        }
    }

    public ScheduledThreadPoolExecutor getScheduledService() {
        if (this.scheduledService == null) {
            this.createScheduledService();
        }
        return this.scheduledService;
    }

    protected synchronized void createScheduledService() {
        this.scheduledService = new ScheduledThreadPoolExecutor(this.corePoolSize, (ThreadFactory)this.threadFactory, (RejectedExecutionHandler)this.rejectionHandler);
        if (log.isInfoEnabled()) {
            log.info((Object)("scheduled render service created:\n  core pool size : " + this.schedulePoolSize));
        }
    }

    public int getSchedulePoolSize() {
        return this.schedulePoolSize;
    }

    public void setSchedulePoolSize(int schedulePoolSize) {
        this.schedulePoolSize = schedulePoolSize;
    }

    public void dispose() {
        if (this.renderService != null) {
            this.renderService.shutdown();
            this.renderService = null;
        }
        if (this.scheduledService != null) {
            this.scheduledService.shutdown();
            this.scheduledService = null;
        }
    }

    private synchronized void resetCoreService() {
        if (this.renderService != null) {
            this.renderService.shutdown();
            this.createCoreService();
        }
    }

    private synchronized void resetScheduledService() {
        if (this.scheduledService != null) {
            this.scheduledService.shutdown();
            this.createScheduledService();
        }
    }
}

