/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.webapp.http.common.standard;

import com.icesoft.faces.webapp.http.common.Request;
import com.icesoft.faces.webapp.http.common.Server;
import com.icesoft.faces.webapp.http.common.standard.NotFoundHandler;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.regex.Pattern;

public class PathDispatcherServer
implements Server {
    private List matchers = new ArrayList();
    private List servers = new ArrayList();

    public void service(Request request) throws Exception {
        String path = request.getURI().getPath();
        ListIterator i = new ArrayList(this.matchers).listIterator();
        while (i.hasNext()) {
            int index = i.nextIndex();
            Pattern pattern = (Pattern)i.next();
            if (!pattern.matcher(path).find()) continue;
            Server server = (Server)this.servers.get(index);
            server.service(request);
            return;
        }
        request.respondWith(new NotFoundHandler("Could not find resource at " + path));
    }

    public void dispatchOn(String pathExpression, Server toServer) {
        this.matchers.add(Pattern.compile(pathExpression));
        this.servers.add(toServer);
    }

    public void shutdown() {
        Iterator i = this.servers.iterator();
        while (i.hasNext()) {
            Server server = (Server)i.next();
            server.shutdown();
        }
    }
}

