/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.net.messaging;

import com.icesoft.net.messaging.Message;
import com.icesoft.net.messaging.MessageHandler;
import com.icesoft.net.messaging.MessageSelector;
import com.icesoft.net.messaging.TextMessage;
import java.util.Enumeration;
import java.util.StringTokenizer;

public class MessageSeparator
implements MessageHandler {
    private MessageHandler messageHandler;

    public MessageSeparator(MessageHandler messageHandler) {
        this.messageHandler = messageHandler;
    }

    public void addCallback(MessageHandler.Callback callback) {
    }

    public void addCallback(MessageHandler.Callback callback, MessageSelector messageSelector) {
    }

    public MessageSelector getMessageSelector() {
        return this.messageHandler.getMessageSelector();
    }

    public void handle(Message message) {
        if (message instanceof TextMessage && message.propertyExists("message_lengths")) {
            TextMessage _textMessage = (TextMessage)message;
            StringTokenizer _lengths = new StringTokenizer(_textMessage.getStringProperty("message_lengths"), ",");
            int _endIndex = 0;
            while (_lengths.hasMoreTokens()) {
                int _beginIndex = _endIndex;
                _endIndex = _beginIndex + Integer.parseInt(_lengths.nextToken());
                this.messageHandler.handle(MessageSeparator.subMessage(_textMessage, _beginIndex, _endIndex));
            }
        } else {
            this.messageHandler.handle(message);
        }
    }

    public void removeCallback(MessageHandler.Callback callback) {
    }

    public void setMessageSelector(MessageSelector messageSelector) {
        this.messageHandler.setMessageSelector(messageSelector);
    }

    public String toString() {
        return this.messageHandler.toString();
    }

    private static TextMessage subMessage(TextMessage textMessage, int beginIndex, int endIndex) {
        TextMessage _textMessage = new TextMessage(textMessage.getText().substring(beginIndex, endIndex));
        Enumeration _propertyNames = textMessage.getPropertyNames();
        while (_propertyNames.hasMoreElements()) {
            String _propertyName = (String)_propertyNames.nextElement();
            if (_propertyName.equalsIgnoreCase("message_lengths")) continue;
            _textMessage.setObjectProperty(_propertyName, textMessage.getObjectProperty(_propertyName));
        }
        return _textMessage;
    }
}

