/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.webapp.http.servlet;

import com.icesoft.faces.webapp.http.common.ResponseHandler;
import com.icesoft.faces.webapp.http.common.Server;
import com.icesoft.faces.webapp.http.servlet.PseudoServlet;
import com.icesoft.faces.webapp.http.servlet.ServletRequestResponse;
import edu.emory.mathcs.backport.java.util.concurrent.Semaphore;
import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ThreadBlockingAdaptingServlet
implements PseudoServlet {
    private static final Log LOG = LogFactory.getLog((Class)ThreadBlockingAdaptingServlet.class);
    private static final int TIMEOUT = 10;
    private Server server;

    public ThreadBlockingAdaptingServlet(Server server) {
        this.server = server;
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ThreadBlockingRequestResponse requestResponse = new ThreadBlockingRequestResponse(request, response);
        this.server.service(requestResponse);
        requestResponse.blockUntilRespond();
    }

    public void shutdown() {
        this.server.shutdown();
    }

    private class ThreadBlockingRequestResponse
    extends ServletRequestResponse {
        private final Semaphore semaphore;

        public ThreadBlockingRequestResponse(HttpServletRequest request, HttpServletResponse response) throws Exception {
            super(request, response);
            this.semaphore = new Semaphore(1);
            this.semaphore.acquire();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void respondWith(ResponseHandler handler) throws Exception {
            try {
                super.respondWith(handler);
            }
            finally {
                this.semaphore.release();
            }
        }

        public void blockUntilRespond() throws InterruptedException {
            boolean acquired = this.semaphore.tryAcquire(10L, TimeUnit.MINUTES);
            if (acquired) {
                this.semaphore.release();
            } else {
                LOG.error((Object)("No response sent to request '" + this.request.getRequestURI() + "' " + "with ICEfaces ID '" + this.request.getParameter("ice.session") + "' " + "from " + this.request.getRemoteAddr() + " " + "in " + 10 + " minutes.  " + "Unblocking " + "thread '" + Thread.currentThread().getName() + "'."));
                this.semaphore.release();
            }
        }
    }
}

