/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.taglibs.authz;

import java.util.HashSet;
import java.util.StringTokenizer;
import javax.servlet.ServletContext;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.TagSupport;
import org.acegisecurity.Authentication;
import org.acegisecurity.acl.AclEntry;
import org.acegisecurity.acl.AclManager;
import org.acegisecurity.acl.basic.BasicAclEntry;
import org.acegisecurity.context.SecurityContextHolder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.springframework.web.util.ExpressionEvaluationUtils;

public class AclTag
extends TagSupport {
    protected static final Log logger = LogFactory.getLog((Class)(class$org$acegisecurity$taglibs$authz$AclTag == null ? (class$org$acegisecurity$taglibs$authz$AclTag = AclTag.class$("org.acegisecurity.taglibs.authz.AclTag")) : class$org$acegisecurity$taglibs$authz$AclTag));
    private Object domainObject;
    private String hasPermission = "";
    static /* synthetic */ Class class$org$acegisecurity$taglibs$authz$AclTag;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$org$acegisecurity$acl$AclManager;

    public int doStartTag() throws JspException {
        if (null == this.hasPermission || "".equals(this.hasPermission)) {
            return 0;
        }
        String evaledPermissionsString = ExpressionEvaluationUtils.evaluateString((String)"hasPermission", (String)this.hasPermission, (PageContext)this.pageContext);
        Integer[] requiredIntegers = null;
        try {
            requiredIntegers = this.parseIntegersString(evaledPermissionsString);
        }
        catch (NumberFormatException nfe) {
            throw new JspException((Throwable)nfe);
        }
        Object resolvedDomainObject = null;
        resolvedDomainObject = this.domainObject instanceof String ? ExpressionEvaluationUtils.evaluate((String)"domainObject", (String)((String)this.domainObject), (Class)(class$java$lang$Object == null ? (class$java$lang$Object = AclTag.class$("java.lang.Object")) : class$java$lang$Object), (PageContext)this.pageContext) : this.domainObject;
        if (resolvedDomainObject == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"domainObject resolved to null, so including tag body");
            }
            return 1;
        }
        if (SecurityContextHolder.getContext().getAuthentication() == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"SecurityContextHolder did not return a non-null Authentication object, so skipping tag body");
            }
            return 0;
        }
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        ApplicationContext context = this.getContext(this.pageContext);
        String[] beans = BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)context, (Class)(class$org$acegisecurity$acl$AclManager == null ? (class$org$acegisecurity$acl$AclManager = AclTag.class$("org.acegisecurity.acl.AclManager")) : class$org$acegisecurity$acl$AclManager), (boolean)false, (boolean)false);
        if (beans.length == 0) {
            throw new JspException("No AclManager would found the application context: " + context.toString());
        }
        AclManager aclManager = (AclManager)context.getBean(beans[0]);
        AclEntry[] acls = aclManager.getAcls(resolvedDomainObject, auth);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Authentication: '" + auth + "' has: " + (acls == null ? 0 : acls.length) + " AclEntrys for domain object: '" + resolvedDomainObject + "' from AclManager: '" + aclManager.toString() + "'"));
        }
        if (acls == null || acls.length == 0) {
            return 0;
        }
        for (int i = 0; i < acls.length; ++i) {
            if (!(acls[i] instanceof BasicAclEntry)) continue;
            BasicAclEntry processableAcl = (BasicAclEntry)acls[i];
            for (int y = 0; y < requiredIntegers.length; ++y) {
                if (!processableAcl.isPermitted(requiredIntegers[y])) continue;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Including tag body as found permission: " + requiredIntegers[y] + " due to AclEntry: '" + processableAcl + "'"));
                }
                return 1;
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"No permission, so skipping tag body");
        }
        return 0;
    }

    protected ApplicationContext getContext(PageContext pageContext) {
        ServletContext servletContext = pageContext.getServletContext();
        return WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)servletContext);
    }

    public Object getDomainObject() {
        return this.domainObject;
    }

    public String getHasPermission() {
        return this.hasPermission;
    }

    private Integer[] parseIntegersString(String integersString) throws NumberFormatException {
        HashSet<Integer> integers = new HashSet<Integer>();
        StringTokenizer tokenizer = new StringTokenizer(integersString, ",", false);
        while (tokenizer.hasMoreTokens()) {
            String integer = tokenizer.nextToken();
            integers.add(new Integer(integer));
        }
        return integers.toArray(new Integer[0]);
    }

    public void setDomainObject(Object domainObject) {
        this.domainObject = domainObject;
    }

    public void setHasPermission(String hasPermission) {
        this.hasPermission = hasPermission;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

