/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.captcha;

import org.acegisecurity.captcha.CaptchaChannelProcessorTemplate;
import org.acegisecurity.captcha.CaptchaSecurityContext;
import org.springframework.util.Assert;

public class AlwaysTestBelowAverageTimeInMillisBetweenRequestsChannelProcessor
extends CaptchaChannelProcessorTemplate {
    public static final String DEFAULT_KEYWORD = "REQUIRES_CAPTCHA_BELOW_AVERAGE_TIME_IN_MILLIS_REQUESTS";

    public AlwaysTestBelowAverageTimeInMillisBetweenRequestsChannelProcessor() {
        this.setKeyword(DEFAULT_KEYWORD);
    }

    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        Assert.isTrue((this.getThresold() > 0 ? 1 : 0) != 0, (String)"thresold must be > 0");
    }

    boolean isContextValidConcerningHumanity(CaptchaSecurityContext context) {
        int req = context.getHumanRestrictedResourcesRequestsCount();
        float thresold = this.getThresold();
        float duration = System.currentTimeMillis() - context.getLastPassedCaptchaDateInMillis();
        float average = req == 0 ? thresold + 1.0f : duration / (float)req;
        if (context.isHuman() && average > thresold) {
            this.logger.debug((Object)"context is valid : average time between requests < thresold && is human");
            return true;
        }
        this.logger.debug((Object)"context is not valid : request count > thresold or is not human");
        return false;
    }
}

