/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.client;

import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import javax.wsdl.Definition;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.OperationClient;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.async.AxisCallback;
import org.apache.axis2.client.async.Callback;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.context.ServiceContext;
import org.apache.axis2.context.ServiceGroupContext;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.description.OutInAxisOperation;
import org.apache.axis2.description.OutOnlyAxisOperation;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.RobustOutOnlyAxisOperation;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.ListenerManager;
import org.apache.axis2.i18n.Messages;
import org.apache.axis2.util.Counter;
import org.apache.axis2.util.JavaUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ServiceClient {
    protected static final Log log = LogFactory.getLog(ServiceClient.class);
    public static final String ANON_SERVICE = "anonService";
    public static final String AUTO_OPERATION_CLEANUP = "ServiceClient.autoOperationCleanup";
    private static Counter anonServiceCounter = new Counter();
    public static final QName ANON_OUT_ONLY_OP = new QName("http://ws.apache.org/namespaces/axis2", "anonOutonlyOp", "axis2");
    public static final QName ANON_ROBUST_OUT_ONLY_OP = new QName("http://ws.apache.org/namespaces/axis2", "anonRobustOp", "axis2");
    public static final QName ANON_OUT_IN_OP = new QName("http://ws.apache.org/namespaces/axis2", "anonOutInOp", "axis2");
    private AxisService axisService;
    private AxisConfiguration axisConfig;
    private ConfigurationContext configContext;
    private ServiceContext serviceContext;
    private Options options = new Options();
    private Options overrideOptions;
    private ArrayList<OMElement> headers;
    private boolean createConfigCtx;
    private int hashCode;
    private boolean removeAxisService;

    public ServiceClient(ConfigurationContext configContext, AxisService axisService) throws AxisFault {
        this.configureServiceClient(configContext, axisService);
    }

    private void configureServiceClient(ConfigurationContext configContext, AxisService axisService) throws AxisFault {
        if (configContext == null) {
            if (ListenerManager.defaultConfigurationContext == null) {
                ListenerManager.defaultConfigurationContext = configContext = ConfigurationContextFactory.createConfigurationContextFromFileSystem(null, null);
                this.createConfigCtx = true;
            } else {
                configContext = ListenerManager.defaultConfigurationContext;
            }
        }
        this.configContext = configContext;
        this.hashCode = (int)anonServiceCounter.incrementAndGet();
        configContext.getListenerManager();
        this.axisConfig = configContext.getAxisConfiguration();
        if (axisService == null) {
            axisService = this.createAnonymousService();
        }
        this.axisService = axisService;
        if (this.axisConfig.getService(axisService.getName()) == null) {
            axisService.setClientSide(true);
            this.axisConfig.addService(axisService);
            this.removeAxisService = true;
        } else {
            axisService.setClientSide(true);
            this.removeAxisService = false;
        }
        AxisServiceGroup axisServiceGroup = axisService.getAxisServiceGroup();
        ServiceGroupContext sgc = configContext.createServiceGroupContext(axisServiceGroup);
        this.serviceContext = sgc.getServiceContext(axisService);
    }

    public ServiceClient(ConfigurationContext configContext, Definition wsdl4jDefinition, QName wsdlServiceName, String portName) throws AxisFault {
        this.configureServiceClient(configContext, AxisService.createClientSideAxisService(wsdl4jDefinition, wsdlServiceName, portName, this.options));
    }

    public ServiceClient(ConfigurationContext configContext, URL wsdlURL, QName wsdlServiceName, String portName) throws AxisFault {
        this.configureServiceClient(configContext, AxisService.createClientSideAxisService(wsdlURL, wsdlServiceName, portName, this.options));
        Parameter transportName = this.axisService.getParameter("TRANSPORT_NAME");
        if (transportName != null) {
            TransportOutDescription transportOut = configContext.getAxisConfiguration().getTransportOut(transportName.getValue().toString());
            if (transportOut == null) {
                throw new AxisFault("Cannot load transport from binding, either defin in Axis2.config or set it explicitely in ServiceClinet.Options");
            }
            this.options.setTransportOut(transportOut);
        }
    }

    public ServiceClient() throws AxisFault {
        this(null, null);
    }

    private AxisService createAnonymousService() {
        AxisService axisService = new AxisService(ANON_SERVICE + anonServiceCounter.incrementAndGet());
        RobustOutOnlyAxisOperation robustoutoonlyOperation = new RobustOutOnlyAxisOperation(ANON_ROBUST_OUT_ONLY_OP);
        axisService.addOperation(robustoutoonlyOperation);
        OutOnlyAxisOperation outOnlyOperation = new OutOnlyAxisOperation(ANON_OUT_ONLY_OP);
        axisService.addOperation(outOnlyOperation);
        OutInAxisOperation outInOperation = new OutInAxisOperation(ANON_OUT_IN_OP);
        axisService.addOperation(outInOperation);
        return axisService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AxisConfiguration getAxisConfiguration() {
        AxisConfiguration axisConfiguration = this.axisConfig;
        synchronized (axisConfiguration) {
            return this.axisConfig;
        }
    }

    public AxisService getAxisService() {
        return this.axisService;
    }

    public void setOptions(Options options) {
        this.options = options;
    }

    public Options getOptions() {
        return this.options;
    }

    public void setOverrideOptions(Options overrideOptions) {
        this.overrideOptions = overrideOptions;
    }

    public Options getOverrideOptions() {
        return this.overrideOptions;
    }

    public void engageModule(QName moduleName) throws AxisFault {
        this.engageModule(moduleName.getLocalPart());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void engageModule(String moduleName) throws AxisFault {
        AxisConfiguration axisConfiguration = this.axisConfig;
        synchronized (axisConfiguration) {
            AxisModule module = this.axisConfig.getModule(moduleName);
            if (module == null) {
                throw new AxisFault("Unable to engage module : " + moduleName);
            }
            this.axisService.engageModule(module);
        }
    }

    public void disengageModule(QName moduleName) {
        this.disengageModule(moduleName.getLocalPart());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disengageModule(String moduleName) {
        AxisConfiguration axisConfiguration = this.axisConfig;
        synchronized (axisConfiguration) {
            AxisModule module = this.axisConfig.getModule(moduleName);
            if (module != null) {
                try {
                    this.axisService.disengageModule(module);
                }
                catch (AxisFault axisFault) {
                    log.error((Object)axisFault.getMessage(), (Throwable)axisFault);
                }
            }
        }
    }

    public void addHeader(OMElement header) {
        if (this.headers == null) {
            this.headers = new ArrayList();
        }
        this.headers.add(header);
    }

    public void addHeader(SOAPHeaderBlock header) {
        if (this.headers == null) {
            this.headers = new ArrayList();
        }
        this.headers.add((OMElement)header);
    }

    public void removeHeaders() {
        if (this.headers != null) {
            this.headers.clear();
        }
    }

    public void addStringHeader(QName headerName, String headerText) throws AxisFault {
        if (headerName.getNamespaceURI() == null || "".equals(headerName.getNamespaceURI())) {
            throw new AxisFault("Failed to add string header, you have to have namespaceURI for the QName");
        }
        OMElement omElement = OMAbstractFactory.getOMFactory().createOMElement(headerName, null);
        omElement.setText(headerText);
        this.addHeader(omElement);
    }

    public void sendRobust(OMElement elem) throws AxisFault {
        this.sendRobust(ANON_ROBUST_OUT_ONLY_OP, elem);
    }

    public void sendRobust(QName operation, OMElement elem) throws AxisFault {
        MessageContext mc = new MessageContext();
        this.fillSOAPEnvelope(mc, elem);
        OperationClient mepClient = this.createClient(operation);
        mepClient.addMessageContext(mc);
        mepClient.execute(true);
    }

    public void fireAndForget(OMElement elem) throws AxisFault {
        this.fireAndForget(ANON_OUT_ONLY_OP, elem);
    }

    public void fireAndForget(QName operation, OMElement elem) throws AxisFault {
        OperationClient mepClient = this.createClient(operation);
        MessageContext mc = new MessageContext();
        this.fillSOAPEnvelope(mc, elem);
        mepClient.addMessageContext(mc);
        mepClient.execute(false);
    }

    public OMElement sendReceive(OMElement elem) throws AxisFault {
        return this.sendReceive(ANON_OUT_IN_OP, elem);
    }

    public OMElement sendReceive(QName operationQName, OMElement xmlPayload) throws AxisFault {
        MessageContext messageContext = new MessageContext();
        this.fillSOAPEnvelope(messageContext, xmlPayload);
        OperationClient operationClient = this.createClient(operationQName);
        operationClient.addMessageContext(messageContext);
        operationClient.execute(true);
        MessageContext response = operationClient.getMessageContext("In");
        if (this.options.isCallTransportCleanup()) {
            response.getEnvelope().build();
            this.cleanupTransport();
        }
        return response.getEnvelope().getBody().getFirstElement();
    }

    public void sendReceiveNonBlocking(OMElement elem, Callback callback) throws AxisFault {
        this.sendReceiveNonBlocking(ANON_OUT_IN_OP, elem, callback);
    }

    public void sendReceiveNonBlocking(OMElement elem, AxisCallback callback) throws AxisFault {
        this.sendReceiveNonBlocking(ANON_OUT_IN_OP, elem, callback);
    }

    public void sendReceiveNonBlocking(QName operation, OMElement elem, Callback callback) throws AxisFault {
        MessageContext mc = new MessageContext();
        this.fillSOAPEnvelope(mc, elem);
        OperationClient mepClient = this.createClient(operation);
        mepClient.setCallback(callback);
        mepClient.addMessageContext(mc);
        mepClient.execute(false);
    }

    public void sendReceiveNonBlocking(QName operation, OMElement elem, AxisCallback callback) throws AxisFault {
        MessageContext mc = new MessageContext();
        this.fillSOAPEnvelope(mc, elem);
        OperationClient mepClient = this.createClient(operation);
        mepClient.setCallback(callback);
        mepClient.addMessageContext(mc);
        mepClient.execute(false);
    }

    public OperationClient createClient(QName operationQName) throws AxisFault {
        AxisOperation axisOperation;
        if (JavaUtils.isTrue(this.getOptions().getProperty(AUTO_OPERATION_CLEANUP), true) && !this.getOptions().isUseSeparateListener()) {
            this.cleanupTransport();
        }
        if ((axisOperation = this.axisService.getOperation(operationQName)) == null) {
            throw new AxisFault(Messages.getMessage("operationnotfound", operationQName.getLocalPart()));
        }
        Iterator<String> i$ = this.options.getProperties().keySet().iterator();
        while (i$.hasNext()) {
            String o;
            String key = o = i$.next();
            this.serviceContext.setProperty(key, this.options.getProperties().get(key));
        }
        OperationClient operationClient = axisOperation.createClient(this.serviceContext, this.options);
        if (this.overrideOptions != null) {
            this.overrideOptions.setParent(operationClient.getOptions());
            operationClient.setOptions(this.overrideOptions);
        }
        return operationClient;
    }

    private SOAPFactory getSOAPFactory() {
        String soapVersionURI = this.options.getSoapVersionURI();
        if ("http://www.w3.org/2003/05/soap-envelope".equals(soapVersionURI)) {
            return OMAbstractFactory.getSOAP12Factory();
        }
        return OMAbstractFactory.getSOAP11Factory();
    }

    private void fillSOAPEnvelope(MessageContext messageContext, OMElement xmlPayload) throws AxisFault {
        messageContext.setServiceContext(this.serviceContext);
        SOAPFactory soapFactory = this.getSOAPFactory();
        SOAPEnvelope envelope = soapFactory.getDefaultEnvelope();
        if (xmlPayload != null) {
            envelope.getBody().addChild((OMNode)xmlPayload);
        }
        this.addHeadersToEnvelope(envelope);
        messageContext.setEnvelope(envelope);
    }

    public void addHeadersToEnvelope(SOAPEnvelope envelope) {
        if (this.headers != null) {
            SOAPHeader soapHeader = envelope.getHeader();
            for (OMElement header : this.headers) {
                soapHeader.addChild((OMNode)header);
            }
        }
    }

    public EndpointReference getMyEPR(String transport) throws AxisFault {
        return this.serviceContext.getMyEPR(transport);
    }

    public EndpointReference getTargetEPR() {
        return this.serviceContext.getTargetEPR();
    }

    public void setTargetEPR(EndpointReference targetEpr) {
        this.serviceContext.setTargetEPR(targetEpr);
        this.options.setTo(targetEpr);
    }

    public OperationContext getLastOperationContext() {
        return this.serviceContext.getLastOperationContext();
    }

    public void setCachingOperationContext(boolean cachingOpContext) {
        this.serviceContext.setCachingOperationContext(cachingOpContext);
    }

    public ServiceContext getServiceContext() {
        return this.serviceContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.cleanup();
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            super.finalize();
            throw throwable;
        }
        super.finalize();
    }

    public void cleanup() throws AxisFault {
        if (!this.createConfigCtx) {
            String serviceGroupName = this.axisService.getAxisServiceGroup().getServiceGroupName();
            AxisConfiguration axisConfiguration = this.configContext.getAxisConfiguration();
            AxisServiceGroup asg = axisConfiguration.getServiceGroup(serviceGroupName);
            if (asg != null && this.removeAxisService) {
                axisConfiguration.removeServiceGroup(serviceGroupName);
            }
        } else {
            this.configContext.terminate();
        }
    }

    public void cleanupTransport() throws AxisFault {
        MessageContext outMessageContext;
        OperationContext lastOperationContext = this.getLastOperationContext();
        if (lastOperationContext != null && (outMessageContext = lastOperationContext.getMessageContext("Out")) != null) {
            outMessageContext.getTransportOut().getSender().cleanup(outMessageContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAxisService(AxisService axisService) throws AxisFault {
        if (axisService == null) {
            throw new IllegalArgumentException("AxisService is null");
        }
        AxisConfiguration axisConfiguration = this.axisConfig;
        synchronized (axisConfiguration) {
            this.axisConfig.removeService(this.axisService.getName());
            this.axisService = axisService;
            axisService.setClientSide(true);
            this.axisConfig.addService(axisService);
        }
        AxisServiceGroup axisServiceGroup = axisService.getAxisServiceGroup();
        ServiceGroupContext serviceGroupContext = this.configContext.createServiceGroupContext(axisServiceGroup);
        this.serviceContext = serviceGroupContext.getServiceContext(axisService);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceClient)) {
            return false;
        }
        ServiceClient other = (ServiceClient)obj;
        return this.hashCode == other.hashCode;
    }
}

