/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.env;

import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.StringUtils;
import org.springframework.web.context.ConfigurableWebApplicationContext;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.XmlWebApplicationContext;
import org.springframework.webflow.executor.FlowExecutor;

public class SpringWebFlowInstantiationServlet
extends HttpServlet {
    protected static Log log = LogFactory.getLog((Class)SpringWebFlowInstantiationServlet.class);
    private static String CONFIG_PARAM_NAME = "contextConfigLocation";
    private static FlowExecutor flowExecutor = null;
    private ConfigurableWebApplicationContext container;

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        try {
            this.initFlowExecutor(servletConfig);
        }
        catch (Throwable t) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Unable to initialize SpringWebFlowInstantiationServlet ", t);
            }
            throw new ServletException("Unable to initialize SpringWebFlowInstantiationServlet ", t);
        }
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
    }

    public void destroy() {
        this.container.close();
    }

    public static FlowExecutor getFlowExecutor() {
        return flowExecutor;
    }

    void initFlowExecutor(ServletConfig config) {
        this.container = new XmlWebApplicationContext();
        this.container.setConfigLocations(this.getConfigLocations(config));
        this.container.setServletConfig(config);
        this.container.setServletContext(config.getServletContext());
        this.container.refresh();
        flowExecutor = this.lookupFlowExecutor((WebApplicationContext)this.container);
    }

    private String[] getConfigLocations(ServletConfig config) {
        String configLocations = config.getInitParameter(CONFIG_PARAM_NAME);
        if (configLocations != null) {
            return StringUtils.tokenizeToStringArray((String)config.getInitParameter(CONFIG_PARAM_NAME), (String)",; \t\n");
        }
        return new String[]{"/WEB-INF/config/web-application-config.xml"};
    }

    private FlowExecutor lookupFlowExecutor(WebApplicationContext container) {
        String[] beanNames = container.getBeanNamesForType(FlowExecutor.class);
        if (beanNames.length == 0) {
            throw new IllegalStateException("No bean of type FlowExecutor defined in context");
        }
        if (beanNames.length > 1) {
            throw new IllegalStateException("More than one bean of type FlowExecutor defined in context.");
        }
        return (FlowExecutor)container.getBean(beanNames[0]);
    }
}

