/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.acl.basic.jdbc;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Vector;
import javax.sql.DataSource;
import org.acegisecurity.acl.basic.AclObjectIdentity;
import org.acegisecurity.acl.basic.BasicAclDao;
import org.acegisecurity.acl.basic.BasicAclEntry;
import org.acegisecurity.acl.basic.NamedEntityObjectIdentity;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContextException;
import org.springframework.jdbc.core.SqlParameter;
import org.springframework.jdbc.core.support.JdbcDaoSupport;
import org.springframework.jdbc.object.MappingSqlQuery;
import org.springframework.util.Assert;

public class JdbcDaoImpl
extends JdbcDaoSupport
implements BasicAclDao {
    public static final String RECIPIENT_USED_FOR_INHERITENCE_MARKER = "___INHERITENCE_MARKER_ONLY___";
    public static final String DEF_ACLS_BY_OBJECT_IDENTITY_QUERY = "SELECT RECIPIENT, MASK FROM acl_permission WHERE acl_object_identity = ?";
    public static final String DEF_OBJECT_PROPERTIES_QUERY = "SELECT CHILD.ID, CHILD.OBJECT_IDENTITY, CHILD.ACL_CLASS, PARENT.OBJECT_IDENTITY as PARENT_OBJECT_IDENTITY FROM acl_object_identity as CHILD LEFT OUTER JOIN acl_object_identity as PARENT ON CHILD.parent_object=PARENT.id WHERE CHILD.object_identity = ?";
    private static final Log logger = LogFactory.getLog((Class)(class$org$acegisecurity$acl$basic$jdbc$JdbcDaoImpl == null ? (class$org$acegisecurity$acl$basic$jdbc$JdbcDaoImpl = JdbcDaoImpl.class$("org.acegisecurity.acl.basic.jdbc.JdbcDaoImpl")) : class$org$acegisecurity$acl$basic$jdbc$JdbcDaoImpl));
    protected MappingSqlQuery aclsByObjectIdentity;
    protected MappingSqlQuery objectProperties;
    private String aclsByObjectIdentityQuery = "SELECT RECIPIENT, MASK FROM acl_permission WHERE acl_object_identity = ?";
    private String objectPropertiesQuery = "SELECT CHILD.ID, CHILD.OBJECT_IDENTITY, CHILD.ACL_CLASS, PARENT.OBJECT_IDENTITY as PARENT_OBJECT_IDENTITY FROM acl_object_identity as CHILD LEFT OUTER JOIN acl_object_identity as PARENT ON CHILD.parent_object=PARENT.id WHERE CHILD.object_identity = ?";
    static /* synthetic */ Class class$org$acegisecurity$acl$basic$jdbc$JdbcDaoImpl;
    static /* synthetic */ Class class$org$acegisecurity$acl$basic$NamedEntityObjectIdentity;

    protected String convertAclObjectIdentityToString(AclObjectIdentity aclObjectIdentity) {
        Assert.isInstanceOf((Class)(class$org$acegisecurity$acl$basic$NamedEntityObjectIdentity == null ? (class$org$acegisecurity$acl$basic$NamedEntityObjectIdentity = JdbcDaoImpl.class$("org.acegisecurity.acl.basic.NamedEntityObjectIdentity")) : class$org$acegisecurity$acl$basic$NamedEntityObjectIdentity), (Object)aclObjectIdentity, (String)("Only aclObjectIdentity of type NamedEntityObjectIdentity supported (was passed: " + aclObjectIdentity + ")"));
        NamedEntityObjectIdentity neoi = (NamedEntityObjectIdentity)aclObjectIdentity;
        return neoi.getClassname() + ":" + neoi.getId();
    }

    private BasicAclEntry createBasicAclEntry(AclDetailsHolder propertiesInformation, AclDetailsHolder aclInformation) {
        BasicAclEntry entry;
        try {
            entry = (BasicAclEntry)propertiesInformation.getAclClass().newInstance();
        }
        catch (InstantiationException ie) {
            throw new IllegalArgumentException(ie.getMessage());
        }
        catch (IllegalAccessException iae) {
            throw new IllegalArgumentException(iae.getMessage());
        }
        entry.setAclObjectIdentity(propertiesInformation.getAclObjectIdentity());
        entry.setAclObjectParentIdentity(propertiesInformation.getAclObjectParentIdentity());
        if (aclInformation == null) {
            entry.setMask(0);
            entry.setRecipient(RECIPIENT_USED_FOR_INHERITENCE_MARKER);
        } else {
            entry.setMask(aclInformation.getMask());
            entry.setRecipient(aclInformation.getRecipient());
        }
        return entry;
    }

    public BasicAclEntry[] getAcls(AclObjectIdentity aclObjectIdentity) {
        String aclObjectIdentityString;
        try {
            aclObjectIdentityString = this.convertAclObjectIdentityToString(aclObjectIdentity);
        }
        catch (IllegalArgumentException unsupported) {
            return null;
        }
        List objects = this.objectProperties.execute(aclObjectIdentityString);
        if (objects.size() == 0) {
            return null;
        }
        AclDetailsHolder propertiesInformation = (AclDetailsHolder)objects.get(0);
        List acls = this.aclsByObjectIdentity.execute(propertiesInformation.getForeignKeyId());
        if (acls.size() == 0) {
            return new BasicAclEntry[]{this.createBasicAclEntry(propertiesInformation, null)};
        }
        AclDetailsHolder[] aclHolders = acls.toArray(new AclDetailsHolder[0]);
        Vector<BasicAclEntry> toReturnAcls = new Vector<BasicAclEntry>();
        for (int i = 0; i < aclHolders.length; ++i) {
            toReturnAcls.add(this.createBasicAclEntry(propertiesInformation, aclHolders[i]));
        }
        return toReturnAcls.toArray(new BasicAclEntry[0]);
    }

    public MappingSqlQuery getAclsByObjectIdentity() {
        return this.aclsByObjectIdentity;
    }

    public String getAclsByObjectIdentityQuery() {
        return this.aclsByObjectIdentityQuery;
    }

    public String getObjectPropertiesQuery() {
        return this.objectPropertiesQuery;
    }

    protected void initDao() throws ApplicationContextException {
        this.initMappingSqlQueries();
    }

    protected void initMappingSqlQueries() {
        this.setAclsByObjectIdentity(new AclsByObjectIdentityMapping(this.getDataSource()));
        this.setObjectProperties(new ObjectPropertiesMapping(this.getDataSource()));
    }

    public void setAclsByObjectIdentity(MappingSqlQuery aclsByObjectIdentityQuery) {
        this.aclsByObjectIdentity = aclsByObjectIdentityQuery;
    }

    public void setAclsByObjectIdentityQuery(String queryString) {
        this.aclsByObjectIdentityQuery = queryString;
    }

    public void setObjectProperties(MappingSqlQuery objectPropertiesQuery) {
        this.objectProperties = objectPropertiesQuery;
    }

    public void setObjectPropertiesQuery(String queryString) {
        this.objectPropertiesQuery = queryString;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected class ObjectPropertiesMapping
    extends MappingSqlQuery {
        protected ObjectPropertiesMapping(DataSource ds) {
            super(ds, JdbcDaoImpl.this.objectPropertiesQuery);
            this.declareParameter(new SqlParameter(12));
            this.compile();
        }

        private AclObjectIdentity buildIdentity(String identity) {
            if (identity == null) {
                return null;
            }
            int delim = identity.lastIndexOf(":");
            String classname = identity.substring(0, delim);
            String id = identity.substring(delim + 1);
            return new NamedEntityObjectIdentity(classname, id);
        }

        protected Object mapRow(ResultSet rs, int rownum) throws SQLException {
            Class<?> aclClazz;
            long id = rs.getLong(1);
            String objectIdentity = rs.getString(2);
            String aclClass = rs.getString(3);
            String parentObjectIdentity = rs.getString(4);
            Assert.hasText((String)objectIdentity, (String)"required DEF_OBJECT_PROPERTIES_QUERY value (objectIdentity) returned null or empty");
            Assert.hasText((String)aclClass, (String)"required DEF_OBJECT_PROPERTIES_QUERY value (aclClass) returned null or empty");
            try {
                aclClazz = ((Object)((Object)this)).getClass().getClassLoader().loadClass(aclClass);
            }
            catch (ClassNotFoundException cnf) {
                throw new IllegalArgumentException(cnf.getMessage());
            }
            return new AclDetailsHolder(id, this.buildIdentity(objectIdentity), this.buildIdentity(parentObjectIdentity), aclClazz);
        }
    }

    protected class AclsByObjectIdentityMapping
    extends MappingSqlQuery {
        protected AclsByObjectIdentityMapping(DataSource ds) {
            super(ds, JdbcDaoImpl.this.aclsByObjectIdentityQuery);
            this.declareParameter(new SqlParameter(-5));
            this.compile();
        }

        protected Object mapRow(ResultSet rs, int rownum) throws SQLException {
            String recipient = rs.getString(1);
            int mask = rs.getInt(2);
            Assert.hasText((String)recipient, (String)"recipient required");
            return new AclDetailsHolder(recipient, mask);
        }
    }

    protected final class AclDetailsHolder {
        private AclObjectIdentity aclObjectIdentity;
        private AclObjectIdentity aclObjectParentIdentity;
        private Class aclClass;
        private Object recipient;
        private int mask;
        private long foreignKeyId;

        public AclDetailsHolder(Object recipient, int mask) {
            this.recipient = recipient;
            this.mask = mask;
        }

        public AclDetailsHolder(long foreignKeyId, AclObjectIdentity aclObjectIdentity, AclObjectIdentity aclObjectParentIdentity, Class aclClass) {
            this.foreignKeyId = foreignKeyId;
            this.aclObjectIdentity = aclObjectIdentity;
            this.aclObjectParentIdentity = aclObjectParentIdentity;
            this.aclClass = aclClass;
        }

        public Class getAclClass() {
            return this.aclClass;
        }

        public AclObjectIdentity getAclObjectIdentity() {
            return this.aclObjectIdentity;
        }

        public AclObjectIdentity getAclObjectParentIdentity() {
            return this.aclObjectParentIdentity;
        }

        public long getForeignKeyId() {
            return this.foreignKeyId;
        }

        public int getMask() {
            return this.mask;
        }

        public Object getRecipient() {
            return this.recipient;
        }
    }
}

