/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.xml.BeanDefinitionDecorator;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.security.util.RegexUrlPathMatcher;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class FilterChainMapBeanDefinitionDecorator
implements BeanDefinitionDecorator {
    FilterChainMapBeanDefinitionDecorator() {
    }

    public BeanDefinitionHolder decorate(Node node, BeanDefinitionHolder holder, ParserContext parserContext) {
        BeanDefinition filterChainProxy = holder.getBeanDefinition();
        LinkedHashMap filterChainMap = new LinkedHashMap();
        Element elt = (Element)node;
        String pathType = elt.getAttribute("path-type");
        if ("regex".equals(pathType)) {
            filterChainProxy.getPropertyValues().addPropertyValue("matcher", (Object)new RegexUrlPathMatcher());
        }
        Iterator filterChainElts = DomUtils.getChildElementsByTagName((Element)elt, (String)"filter-chain").iterator();
        while (filterChainElts.hasNext()) {
            String filters;
            Element chain = (Element)filterChainElts.next();
            String path = chain.getAttribute("pattern");
            if (!StringUtils.hasText((String)path)) {
                parserContext.getReaderContext().error("The attribute 'pattern' must not be empty", (Object)elt);
            }
            if (!StringUtils.hasText((String)(filters = chain.getAttribute("filters")))) {
                parserContext.getReaderContext().error("The attribute 'filters'must not be empty", (Object)elt);
            }
            if (filters.equals("none")) {
                filterChainMap.put(path, Collections.EMPTY_LIST);
                continue;
            }
            String[] filterBeanNames = StringUtils.tokenizeToStringArray((String)filters, (String)",");
            ManagedList filterChain = new ManagedList(filterBeanNames.length);
            for (int i = 0; i < filterBeanNames.length; ++i) {
                filterChain.add(new RuntimeBeanReference(filterBeanNames[i]));
            }
            filterChainMap.put(path, filterChain);
        }
        ManagedMap map = new ManagedMap(filterChainMap.size());
        map.putAll(filterChainMap);
        filterChainProxy.getPropertyValues().addPropertyValue("filterChainMap", (Object)map);
        return holder;
    }
}

