/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.webapp.http.core;

import com.icesoft.faces.component.inputfile.FileInfo;
import com.icesoft.faces.component.inputfile.FileUploadInvalidNamePatternException;
import com.icesoft.faces.component.inputfile.FileUploadUnspecifiedNameException;
import com.icesoft.faces.component.inputfile.UploadConfig;
import com.icesoft.faces.component.inputfile.UploadStateHolder;
import com.icesoft.faces.context.BridgeFacesContext;
import com.icesoft.faces.context.View;
import com.icesoft.faces.webapp.http.common.Configuration;
import com.icesoft.faces.webapp.http.common.Request;
import com.icesoft.faces.webapp.http.common.Server;
import com.icesoft.faces.webapp.http.common.standard.StringContentHandler;
import com.icesoft.faces.webapp.xmlhttp.PersistentFacesState;
import com.icesoft.util.SeamUtilities;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItemIterator;
import org.apache.commons.fileupload.FileItemStream;
import org.apache.commons.fileupload.FileUploadBase;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.MultipartStream;
import org.apache.commons.fileupload.ProgressListener;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.fileupload.util.Streams;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UploadServer
implements Server {
    private static final Log log = LogFactory.getLog((Class)UploadServer.class);
    private Map views;
    private long maxSize;
    private boolean uniqueFolder;
    private String uploadDirectory;
    private boolean uploadDirectoryAbsolute;
    private boolean lifecycleOnCallingThread;

    public UploadServer(Map views, Configuration configuration) {
        this.views = views;
        this.maxSize = configuration.getAttributeAsLong("uploadMaxFileSize", 0x300000L);
        this.uniqueFolder = configuration.getAttributeAsBoolean("uniqueFolder", false);
        this.uploadDirectory = configuration.getAttribute("uploadDirectory", "");
        this.uploadDirectoryAbsolute = configuration.getAttributeAsBoolean("uploadDirectoryAbsolute", false);
        this.lifecycleOnCallingThread = configuration.getAttributeAsBoolean("forceLifecycleOnCallingThread", false);
    }

    public void service(final Request request) throws Exception {
        final ServletFileUpload uploader = new ServletFileUpload();
        final ProgressCalculator progressCalculator = new ProgressCalculator(this.lifecycleOnCallingThread);
        uploader.setFileSizeMax(this.maxSize);
        uploader.setProgressListener(new ProgressListener(){

            public void update(long read, long total, int chunkIndex) {
                progressCalculator.progress(read, total);
            }
        });
        request.detectEnvironment(new Request.Environment(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             */
            public void servlet(Object req, Object resp) throws Exception {
                block19: {
                    HttpServletRequest servletRequest = (HttpServletRequest)req;
                    FileItemIterator iter = uploader.getItemIterator(servletRequest);
                    String viewIdentifier = null;
                    String componentID = null;
                    try {
                        while (iter.hasNext()) {
                            FileItemStream item = iter.next();
                            if (item.isFormField()) {
                                String name = item.getFieldName();
                                if ("ice.component".equals(name)) {
                                    componentID = Streams.asString((InputStream)item.openStream());
                                    continue;
                                }
                                if (!"ice.view".equals(name)) continue;
                                viewIdentifier = Streams.asString((InputStream)item.openStream());
                                continue;
                            }
                            View view = (View)UploadServer.this.views.get(viewIdentifier);
                            view.installThreadLocals();
                            PersistentFacesState state = view.getPersistentFacesState();
                            BridgeFacesContext context = view.getFacesContext();
                            if (log.isDebugEnabled()) {
                                log.debug((Object)"UploadServer");
                                log.debug((Object)("  viewIdentifier: " + viewIdentifier));
                                log.debug((Object)("  componentID: " + componentID));
                            }
                            UploadConfig componentUploadConfig = null;
                            String key = viewIdentifier + " " + componentID;
                            Object sessionObj = context.getExternalContext().getSession(false);
                            if (sessionObj != null) {
                                Object object = sessionObj;
                                synchronized (object) {
                                    Map map = context.getExternalContext().getSessionMap();
                                    componentUploadConfig = (UploadConfig)map.get(key);
                                }
                            }
                            UploadConfig uploadConfig = new UploadConfig(componentUploadConfig, componentID, UploadServer.this.maxSize, UploadServer.this.uniqueFolder, UploadServer.this.uploadDirectory, UploadServer.this.uploadDirectoryAbsolute);
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("  session map key: " + key));
                                log.debug((Object)("  componentUploadConfig: " + componentUploadConfig));
                                log.debug((Object)("  uploadConfig: " + uploadConfig));
                            }
                            FileInfo fileInfo = new FileInfo();
                            fileInfo.setStatus(1);
                            progressCalculator.setLifecycleState(state, uploadConfig, fileInfo);
                            String iframeContent = null;
                            try {
                                this.upload(item, fileInfo, uploadConfig, servletRequest.getSession().getServletContext(), servletRequest.getRequestedSessionId());
                                UploadStateHolder stateHolder = progressCalculator.doLifecycle();
                                iframeContent = this.getResultingIframeContent(context, stateHolder);
                                request.respondWith(new StringContentHandler("text/html", "UTF-8", iframeContent));
                            }
                            catch (IOException e) {
                                log.warn((Object)"File upload problem", (Throwable)e);
                            }
                            catch (Throwable t) {
                                log.warn((Object)"File upload issue", t);
                                {
                                    catch (Throwable throwable) {
                                        throw throwable;
                                    }
                                }
                                request.respondWith(new StringContentHandler("text/html", "UTF-8", iframeContent));
                            }
                            finally {
                                request.respondWith(new StringContentHandler("text/html", "UTF-8", iframeContent));
                            }
                        }
                    }
                    catch (MultipartStream.MalformedStreamException exception) {
                        if (log.isTraceEnabled()) {
                            log.trace((Object)"Connection broken by client.", (Throwable)exception);
                        }
                        if (!log.isDebugEnabled()) break block19;
                        log.debug((Object)("Connection broken by client: " + exception.getMessage()));
                    }
                }
            }

            protected void upload(FileItemStream stream, FileInfo fileInfo, UploadConfig uploadConfig, ServletContext servletContext, String sessionId) throws IOException {
                block24: {
                    String folder = uploadConfig.getUploadDirectory();
                    Boolean folderAbs = uploadConfig.getUploadDirectoryAbsolute();
                    if (!folderAbs.booleanValue()) {
                        folder = servletContext.getRealPath(folder);
                    }
                    if (uploadConfig.getUniqueFolder().booleanValue()) {
                        String FILE_SEPARATOR = System.getProperty("file.separator");
                        folder = folder + FILE_SEPARATOR + sessionId;
                    }
                    String namePattern = uploadConfig.getFileNamePattern().trim();
                    String fileName = stream.getName();
                    File file = null;
                    if (File.separatorChar == '/' && fileName.matches("^[a-zA-Z]:\\\\.*?|^\\\\\\\\.*?")) {
                        fileName = fileName.substring(fileName.lastIndexOf("\\") + 1);
                    }
                    try {
                        long fileLength;
                        if (fileName == null || fileName.length() <= 0) {
                            throw new FileUploadUnspecifiedNameException();
                        }
                        File tempFileName = new File(fileName);
                        fileName = tempFileName.getName();
                        fileInfo.setFileName(fileName);
                        fileInfo.setContentType(stream.getContentType());
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("fileNamePattern: " + namePattern));
                            log.debug((Object)("fileName: " + fileName));
                            log.debug((Object)("Matches: " + (fileName != null && fileName.trim().matches(namePattern))));
                        }
                        if (fileName != null && fileName.trim().matches(namePattern)) {
                            File folderFile = new File(folder);
                            if (!folderFile.exists()) {
                                folderFile.mkdirs();
                            }
                            file = new File(folder, fileName);
                            FileOutputStream output = new FileOutputStream(file);
                            Streams.copy((InputStream)stream.openStream(), (OutputStream)output, (boolean)true);
                            fileLength = file.length();
                            if (uploadConfig.isFailOnEmptyFile() && fileLength == 0L) {
                                throw new FileUploadBase.FileUploadIOException((FileUploadException)new FileUploadBase.UnknownSizeException());
                            }
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("fileLength: " + fileLength + (fileLength > uploadConfig.getSizeMax() ? "  TOO LARGE" : "")));
                            }
                        } else {
                            throw new FileUploadInvalidNamePatternException("The file name '" + fileName + "' does not match with the file name pattern '" + namePattern + "'");
                        }
                        fileInfo.setStatus(2);
                        fileInfo.setPercent(100);
                        fileInfo.setFile(file);
                        fileInfo.setSize(fileLength);
                    }
                    catch (FileUploadBase.FileUploadIOException uploadException) {
                        Throwable cause = uploadException.getCause();
                        if (cause instanceof Exception) {
                            fileInfo.setException((Exception)cause);
                        } else {
                            fileInfo.setException((Exception)((Object)uploadException));
                        }
                        try {
                            throw cause;
                        }
                        catch (FileUploadBase.FileSizeLimitExceededException e) {
                            fileInfo.setStatus(4);
                        }
                        catch (FileUploadBase.UnknownSizeException e) {
                            fileInfo.setStatus(5);
                        }
                        catch (FileUploadBase.InvalidContentTypeException e) {
                            fileInfo.setStatus(8);
                        }
                        catch (Throwable t) {
                            fileInfo.setStatus(3);
                        }
                        fileInfo.setPercent(0);
                        if (file != null) {
                            file.delete();
                            file = null;
                        }
                    }
                    catch (FileUploadUnspecifiedNameException e) {
                        fileInfo.setException(e);
                        fileInfo.setStatus(7);
                        fileInfo.setPercent(0);
                    }
                    catch (FileUploadInvalidNamePatternException e) {
                        fileInfo.setException(e);
                        fileInfo.setStatus(6);
                        fileInfo.setPercent(0);
                    }
                    catch (IOException e) {
                        fileInfo.setException(e);
                        fileInfo.setStatus(3);
                        fileInfo.setPercent(0);
                        if (file == null) break block24;
                        file.delete();
                        file = null;
                    }
                }
                log.debug((Object)"upload(-)  Method bottom");
            }

            protected String getResultingIframeContent(BridgeFacesContext context, UploadStateHolder stateHolder) {
                String iframeContent = null;
                long startTime = System.currentTimeMillis();
                do {
                    long now;
                    iframeContent = stateHolder.getIframeContent();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"getResultingIframeContent()");
                        log.debug((Object)"vvvvvvvvvvvvvvvvvvvvvvvvvvv");
                        log.debug((Object)iframeContent);
                        log.debug((Object)"^^^^^^^^^^^^^^^^^^^^^^^^^^^");
                    }
                    if (iframeContent != null || (now = System.currentTimeMillis()) - startTime >= 5000L) break;
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                } while (stateHolder.isAsyncLifecycle());
                return iframeContent;
            }

            public void portlet(Object request2, Object response, Object config) {
                throw new IllegalAccessError("Cannot upload using a portlet request/response.");
            }
        });
    }

    public void shutdown() {
    }

    private static class ProgressCalculator {
        private final int GRANULARITY = 10;
        private final long TIME_MILLISECONDS = 1000L;
        private PersistentFacesState state;
        private UploadConfig uploadConfig;
        private FileInfo fileInfo;
        private int lastGranularlyNotifiablePercent = -1;
        private long lastTime = -1L;
        private boolean lifecycleOnCallingThread;

        public ProgressCalculator(boolean lifecycleOnCallingThread) {
            this.lifecycleOnCallingThread = lifecycleOnCallingThread;
        }

        public void progress(long read, long total) {
            if (total > 0L) {
                long now;
                boolean shouldNotify;
                int percentage = (int)(read * 100L / total);
                int percentageAboveGranularity = percentage % 10;
                int granularNotifiablePercentage = percentage - percentageAboveGranularity;
                boolean bl = shouldNotify = granularNotifiablePercentage > this.lastGranularlyNotifiablePercent;
                if (shouldNotify && this.lastTime > 0L && granularNotifiablePercentage != 0 && granularNotifiablePercentage != 100 && (now = System.currentTimeMillis()) - this.lastTime < 1000L) {
                    shouldNotify = false;
                }
                if (shouldNotify) {
                    this.lastGranularlyNotifiablePercent = granularNotifiablePercentage;
                    this.potentiallyNotify();
                }
            }
        }

        public void setLifecycleState(PersistentFacesState state, UploadConfig uploadConfig, FileInfo fileInfo) {
            this.state = state;
            this.uploadConfig = uploadConfig;
            this.fileInfo = fileInfo;
            if (state != null) {
                state.setAllCurrentInstances();
            }
            this.potentiallyNotify();
        }

        protected void potentiallyNotify() {
            if (this.state != null && this.uploadConfig != null && this.fileInfo != null && !this.fileInfo.isFinished() && this.lastGranularlyNotifiablePercent >= 0 && this.lastGranularlyNotifiablePercent < 100 && !this.state.isSynchronousMode() && this.uploadConfig.isProgressListener() && this.uploadConfig.isProgressRender()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("UploadServer  progress :: " + this.lastGranularlyNotifiablePercent));
                }
                this.fileInfo.setPercent(this.lastGranularlyNotifiablePercent);
                this.doLifecycle();
                this.lastTime = System.currentTimeMillis();
            }
        }

        public UploadStateHolder doLifecycle() {
            UploadStateHolder stateHolder = null;
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("UploadServer  doLifecycle :: " + this.uploadConfig.getClientId() + " in form '" + this.uploadConfig.getFormClientId() + "'" + " -> " + this.fileInfo));
                }
                stateHolder = new UploadStateHolder(this.uploadConfig, (FileInfo)this.fileInfo.clone());
                if (this.lifecycleOnCallingThread || SeamUtilities.isSeamEnvironment() || SeamUtilities.isSpringSecurityEnvironment() || SeamUtilities.isSpringEnvironment()) {
                    stateHolder.setAsyncLifecycle(false);
                    stateHolder.install();
                    this.state.setupAndExecuteAndRender();
                    this.state.setAllCurrentInstances();
                } else {
                    stateHolder.setAsyncLifecycle(true);
                    this.state.renderLater(stateHolder, false);
                    Thread.yield();
                }
            }
            catch (Exception e) {
                log.warn((Object)"Problem rendering view during file upload", (Throwable)e);
            }
            return stateHolder;
        }
    }
}

