/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import org.jivesoftware.smack.ConnectionCreationListener;
import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.StreamError;

public class ReconnectionManager
implements ConnectionListener {
    private int secondBetweenReconnection = 300;
    private Thread reconnectionThread;
    private XMPPConnection connection;
    boolean done = false;

    private ReconnectionManager(XMPPConnection connection) {
        this.connection = connection;
    }

    private boolean isReconnectionAllowed() {
        return !this.done && !this.connection.isConnected() && this.connection.getConfiguration().isReconnectionAllowed() && this.connection.packetReader != null;
    }

    private int getSecondBetweenReconnection() {
        return this.secondBetweenReconnection;
    }

    protected void setSecondBetweenReconnection(int secondBetweenReconnection) {
        this.secondBetweenReconnection = secondBetweenReconnection;
    }

    protected void reconnect() {
        if (this.isReconnectionAllowed()) {
            this.reconnectionThread = new Thread(){
                private int attempts = 0;
                private int firstReconnectionPeriod = 7;
                private int secondReconnectionPeriod = 10 + this.firstReconnectionPeriod;
                private int firstReconnectionTime = 10;
                private int secondReconnectionTime = 60;
                private int lastReconnectionTime = ReconnectionManager.access$100(ReconnectionManager.this);
                private int remainingSeconds = 0;
                private int notificationPeriod = 1000;

                private int timeDelay() {
                    if (this.attempts > this.secondReconnectionPeriod) {
                        return this.lastReconnectionTime;
                    }
                    if (this.attempts > this.firstReconnectionPeriod) {
                        return this.secondReconnectionTime;
                    }
                    return this.firstReconnectionTime;
                }

                public void run() {
                    while (ReconnectionManager.this.isReconnectionAllowed()) {
                        this.remainingSeconds = this.timeDelay();
                        while (ReconnectionManager.this.isReconnectionAllowed() && this.remainingSeconds > 0) {
                            try {
                                Thread.sleep(this.notificationPeriod);
                                --this.remainingSeconds;
                                ReconnectionManager.this.notifyAttemptToReconnectIn(this.remainingSeconds);
                            }
                            catch (InterruptedException e1) {
                                e1.printStackTrace();
                                ReconnectionManager.this.notifyReconnectionFailed(e1);
                            }
                        }
                        try {
                            if (!ReconnectionManager.this.isReconnectionAllowed()) continue;
                            ReconnectionManager.this.connection.connect();
                        }
                        catch (XMPPException e) {
                            ReconnectionManager.this.notifyReconnectionFailed(e);
                        }
                    }
                }
            };
            this.reconnectionThread.setName("Smack Reconnection Manager");
            this.reconnectionThread.setDaemon(true);
            this.reconnectionThread.start();
        }
    }

    protected void notifyReconnectionFailed(Exception exception) {
        if (this.isReconnectionAllowed()) {
            for (ConnectionListener listener : this.connection.packetReader.connectionListeners) {
                listener.reconnectionFailed(exception);
            }
        }
    }

    protected void notifyAttemptToReconnectIn(int seconds) {
        if (this.isReconnectionAllowed()) {
            for (ConnectionListener listener : this.connection.packetReader.connectionListeners) {
                listener.reconnectingIn(seconds);
            }
        }
    }

    public void connectionClosed() {
        this.done = true;
    }

    public void connectionClosedOnError(Exception e) {
        String reason;
        XMPPException xmppEx;
        StreamError error;
        this.done = false;
        if (e instanceof XMPPException && (error = (xmppEx = (XMPPException)e).getStreamError()) != null && "conflict".equals(reason = error.getCode())) {
            return;
        }
        if (this.isReconnectionAllowed()) {
            this.reconnect();
        }
    }

    public void reconnectingIn(int seconds) {
    }

    public void reconnectionFailed(Exception e) {
    }

    public void reconnectionSuccessful() {
    }

    static /* synthetic */ int access$100(ReconnectionManager x0) {
        return x0.getSecondBetweenReconnection();
    }

    static {
        XMPPConnection.addConnectionCreationListener(new ConnectionCreationListener(){

            public void connectionCreated(XMPPConnection connection) {
                connection.addConnectionListener(new ReconnectionManager(connection));
            }
        });
    }
}

