/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config;

import org.springframework.beans.BeanMetadataElement;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.parsing.ComponentDefinition;
import org.springframework.beans.factory.parsing.CompositeComponentDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.security.config.ConfigUtils;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class ConcurrentSessionsBeanDefinitionParser
implements BeanDefinitionParser {
    static final String ATT_EXPIRY_URL = "expired-url";
    static final String ATT_MAX_SESSIONS = "max-sessions";
    static final String ATT_EXCEPTION_IF_MAX_EXCEEDED = "exception-if-maximum-exceeded";
    static final String ATT_SESSION_REGISTRY_ALIAS = "session-registry-alias";
    static final String ATT_SESSION_REGISTRY_REF = "session-registry-ref";
    static /* synthetic */ Class class$org$springframework$security$concurrent$SessionRegistryImpl;
    static /* synthetic */ Class class$org$springframework$security$concurrent$ConcurrentSessionFilter;
    static /* synthetic */ Class class$org$springframework$security$concurrent$ConcurrentSessionControllerImpl;

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        String exceptionIfMaximumExceeded;
        CompositeComponentDefinition compositeDef = new CompositeComponentDefinition(element.getTagName(), parserContext.extractSource((Object)element));
        parserContext.pushContainingComponent(compositeDef);
        BeanDefinitionRegistry beanRegistry = parserContext.getRegistry();
        String sessionRegistryId = element.getAttribute(ATT_SESSION_REGISTRY_REF);
        if (!StringUtils.hasText((String)sessionRegistryId)) {
            RootBeanDefinition sessionRegistry = new RootBeanDefinition(class$org$springframework$security$concurrent$SessionRegistryImpl == null ? (class$org$springframework$security$concurrent$SessionRegistryImpl = ConcurrentSessionsBeanDefinitionParser.class$("org.springframework.security.concurrent.SessionRegistryImpl")) : class$org$springframework$security$concurrent$SessionRegistryImpl);
            beanRegistry.registerBeanDefinition("_sessionRegistry", (BeanDefinition)sessionRegistry);
            parserContext.registerComponent((ComponentDefinition)new BeanComponentDefinition((BeanDefinition)sessionRegistry, "_sessionRegistry"));
            sessionRegistryId = "_sessionRegistry";
        } else {
            beanRegistry.registerAlias(sessionRegistryId, "_sessionRegistry");
        }
        String registryAlias = element.getAttribute(ATT_SESSION_REGISTRY_ALIAS);
        if (StringUtils.hasText((String)registryAlias)) {
            beanRegistry.registerAlias(sessionRegistryId, registryAlias);
        }
        BeanDefinitionBuilder filterBuilder = BeanDefinitionBuilder.rootBeanDefinition((Class)(class$org$springframework$security$concurrent$ConcurrentSessionFilter == null ? (class$org$springframework$security$concurrent$ConcurrentSessionFilter = ConcurrentSessionsBeanDefinitionParser.class$("org.springframework.security.concurrent.ConcurrentSessionFilter")) : class$org$springframework$security$concurrent$ConcurrentSessionFilter));
        filterBuilder.addPropertyValue("sessionRegistry", (Object)new RuntimeBeanReference(sessionRegistryId));
        Object source = parserContext.extractSource((Object)element);
        filterBuilder.setSource(source);
        filterBuilder.setRole(2);
        String expiryUrl = element.getAttribute(ATT_EXPIRY_URL);
        if (StringUtils.hasText((String)expiryUrl)) {
            ConfigUtils.validateHttpRedirect(expiryUrl, parserContext, source);
            filterBuilder.addPropertyValue("expiredUrl", (Object)expiryUrl);
        }
        BeanDefinitionBuilder controllerBuilder = BeanDefinitionBuilder.rootBeanDefinition((Class)(class$org$springframework$security$concurrent$ConcurrentSessionControllerImpl == null ? (class$org$springframework$security$concurrent$ConcurrentSessionControllerImpl = ConcurrentSessionsBeanDefinitionParser.class$("org.springframework.security.concurrent.ConcurrentSessionControllerImpl")) : class$org$springframework$security$concurrent$ConcurrentSessionControllerImpl));
        controllerBuilder.setSource(source);
        controllerBuilder.setRole(2);
        controllerBuilder.addPropertyValue("sessionRegistry", (Object)new RuntimeBeanReference(sessionRegistryId));
        String maxSessions = element.getAttribute(ATT_MAX_SESSIONS);
        if (StringUtils.hasText((String)maxSessions)) {
            controllerBuilder.addPropertyValue("maximumSessions", (Object)maxSessions);
        }
        if (StringUtils.hasText((String)(exceptionIfMaximumExceeded = element.getAttribute(ATT_EXCEPTION_IF_MAX_EXCEEDED)))) {
            controllerBuilder.addPropertyValue("exceptionIfMaximumExceeded", (Object)exceptionIfMaximumExceeded);
        }
        AbstractBeanDefinition controller = controllerBuilder.getBeanDefinition();
        beanRegistry.registerBeanDefinition("_concurrentSessionController", (BeanDefinition)controller);
        parserContext.registerComponent((ComponentDefinition)new BeanComponentDefinition((BeanDefinition)controller, "_concurrentSessionController"));
        beanRegistry.registerBeanDefinition("_concurrentSessionFilter", (BeanDefinition)filterBuilder.getBeanDefinition());
        parserContext.registerComponent((ComponentDefinition)new BeanComponentDefinition((BeanDefinition)filterBuilder.getBeanDefinition(), "_concurrentSessionFilter"));
        ConfigUtils.addHttpFilter(parserContext, (BeanMetadataElement)new RuntimeBeanReference("_concurrentSessionFilter"));
        ConfigUtils.setSessionControllerOnAuthenticationManager(parserContext, "_concurrentSessionController", element);
        parserContext.popAndRegisterContainingComponent();
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

