/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.util;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;
import javax.faces.component.UIComponent;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Entity;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class DOMUtils {
    private static HashSet TAGS_THAT_CAN_CLOSE_SHORT = new HashSet<String>(Arrays.asList("img", "input", "br", "hr", "meta", "base", "link", "frame", "col", "area"));
    private static HashSet TAGS_THAT_ALLOW_NEWLINE = new HashSet<String>(Arrays.asList("img", "input", "td"));
    private static String[] ansiCharacters = new String[]{"nbsp", "iexcl", "cent", "pound", "curren", "yen", "brvbar", "sect", "uml", "copy", "ordf", "laquo", "not", "shy", "reg", "macr", "deg", "plusmn", "sup2", "sup3", "acute", "micro", "para", "middot", "cedil", "sup1", "ordm", "raquo", "frac14", "frac12", "frac34", "iquest", "Agrave", "Aacute", "Acirc", "Atilde", "Auml", "Aring", "AElig", "Ccedil", "Egrave", "Eacute", "Ecirc", "Euml", "Igrave", "Iacute", "Icirc", "Iuml", "ETH", "Ntilde", "Ograve", "Oacute", "Ocirc", "Otilde", "Ouml", "times", "Oslash", "Ugrave", "Uacute", "Ucirc", "Uuml", "Yacute", "THORN", "szlig", "agrave", "aacute", "acirc", "atilde", "auml", "aring", "aelig", "ccedil", "egrave", "eacute", "ecirc", "euml", "igrave", "iacute", "icirc", "iuml", "eth", "ntilde", "ograve", "oacute", "ocirc", "otilde", "ouml", "divide", "oslash", "ugrave", "uacute", "ucirc", "uuml", "yacute", "thorn", "yuml"};

    public static String DocumentTypetoString(String publicID, String systemID, String root) {
        return "<!DOCTYPE " + root + " PUBLIC \"" + publicID + "\" \"" + systemID + "\">";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String nodeToString(Node node) throws IOException {
        StringWriter writer = new StringWriter();
        try {
            DOMUtils.printNode(node, writer);
        }
        finally {
            writer.flush();
            return writer.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String childrenToString(Node node) throws IOException {
        StringWriter writer = new StringWriter();
        try {
            DOMUtils.printChildNodes(node, writer);
        }
        finally {
            writer.flush();
            return writer.toString();
        }
    }

    public static void printChildNodes(Node node, Writer writer) throws IOException {
        NodeList children = node.getChildNodes();
        int l = children.getLength();
        for (int i = 0; i < l; ++i) {
            DOMUtils.printNode(children.item(i), writer);
        }
    }

    public static void printNode(Node node, Writer writer) throws IOException {
        DOMUtils.printNode(node, writer, 0, true, false);
    }

    private static void printNode(Node node, Writer writer, int depth, boolean allowAddingWhitespace, boolean addTrailingNewline) throws IOException {
        switch (node.getNodeType()) {
            case 9: {
                NodeList nodes = node.getChildNodes();
                if (nodes == null) break;
                for (int i = 0; i < nodes.getLength(); ++i) {
                    DOMUtils.printNode(nodes.item(i), writer, depth + 1, allowAddingWhitespace, false);
                }
                break;
            }
            case 1: {
                String name = node.getNodeName();
                writer.write("<");
                writer.write(name);
                NamedNodeMap attributes = node.getAttributes();
                for (int i = 0; i < attributes.getLength(); ++i) {
                    Node current = attributes.item(i);
                    writer.write(" ");
                    writer.write(current.getNodeName());
                    writer.write("=\"");
                    writer.write(DOMUtils.escapeAnsi(current.getNodeValue()));
                    writer.write("\"");
                }
                if (!node.hasChildNodes() && DOMUtils.xmlShortClosingAllowed(node)) {
                    writer.write(" />");
                    break;
                }
                writer.write(">");
                NodeList children = node.getChildNodes();
                if (children != null) {
                    int childrenLength = children.getLength();
                    for (int i = 0; i < childrenLength; ++i) {
                        boolean childAddTrailingNewline = false;
                        if (allowAddingWhitespace && i + 1 < childrenLength) {
                            Node nextChild = children.item(i + 1);
                            childAddTrailingNewline = !DOMUtils.isWhitespaceText(nextChild) && DOMUtils.isNewlineAllowedTag(nextChild);
                        }
                        DOMUtils.printNode(children.item(i), writer, depth + 1, allowAddingWhitespace, childAddTrailingNewline);
                    }
                }
                writer.write("</");
                writer.write(name);
                writer.write(">");
                if (!allowAddingWhitespace || !addTrailingNewline) break;
                writer.write("\n");
                break;
            }
            case 3: {
                writer.write(node.getNodeValue());
            }
        }
    }

    private static boolean isWhitespaceText(Node node) {
        if (node.getNodeType() == 3) {
            String val = node.getNodeValue();
            for (int i = val.length() - 1; i >= 0; --i) {
                if (Character.isWhitespace(val.charAt(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static boolean isNewlineAllowedTag(Node node) {
        short nodeType = node.getNodeType();
        String nodeName = node.getNodeName().toLowerCase();
        return nodeType != 1 || !TAGS_THAT_ALLOW_NEWLINE.contains(nodeName);
    }

    private static boolean isTD(Node node) {
        String name;
        return node.getNodeType() == 1 && (name = node.getNodeName()) != null && name.equalsIgnoreCase("td");
    }

    private static boolean xmlShortClosingAllowed(Node node) {
        short nodeType = node.getNodeType();
        String nodeName = node.getNodeName().toLowerCase();
        return nodeType == 1 && TAGS_THAT_CAN_CLOSE_SHORT.contains(nodeName);
    }

    public static Node getChildByNodeName(Node node, String name) {
        NodeList children = node.getChildNodes();
        int l = children.getLength();
        for (int i = 0; i < l; ++i) {
            Node child = children.item(i);
            if (!child.getNodeName().equalsIgnoreCase(name)) continue;
            return child;
        }
        return null;
    }

    public static Node[] domDiff(Document oldDOM, Document newDOM) {
        Vector nodeDiffs = new Vector();
        DOMUtils.compareNodes(nodeDiffs, oldDOM.getDocumentElement(), newDOM.getDocumentElement());
        return nodeDiffs.toArray(new Node[0]);
    }

    public static boolean compareNodes(List nodeDiffs, Node oldNode, Node newNode) {
        int newChildLength;
        if (!oldNode.getNodeName().equals(newNode.getNodeName())) {
            nodeDiffs.add(newNode.getParentNode());
            return false;
        }
        if (!DOMUtils.compareIDs(oldNode, newNode)) {
            nodeDiffs.add(newNode.getParentNode());
            return false;
        }
        if (!DOMUtils.compareAttributes(oldNode, newNode)) {
            nodeDiffs.add(newNode);
            return false;
        }
        if (!DOMUtils.compareStrings(oldNode.getNodeValue(), newNode.getNodeValue())) {
            nodeDiffs.add(newNode);
            return false;
        }
        NodeList oldChildNodes = oldNode.getChildNodes();
        NodeList newChildNodes = newNode.getChildNodes();
        int oldChildLength = oldChildNodes.getLength();
        if (oldChildLength != (newChildLength = newChildNodes.getLength())) {
            nodeDiffs.add(newNode);
            return false;
        }
        boolean allChildrenMatch = true;
        for (int i = 0; i < newChildLength; ++i) {
            if (DOMUtils.compareNodes(nodeDiffs, oldChildNodes.item(i), newChildNodes.item(i))) continue;
            allChildrenMatch = false;
        }
        return allChildrenMatch;
    }

    private static boolean compareStrings(String oldString, String newString) {
        if (null == oldString && null == newString) {
            return true;
        }
        try {
            return oldString.equals(newString);
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
    }

    public static boolean compareIDs(Node oldNode, Node newNode) {
        if (!(oldNode instanceof Element) && !(newNode instanceof Element)) {
            return true;
        }
        try {
            return ((Element)oldNode).getAttribute("id").equals(((Element)newNode).getAttribute("id"));
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean compareAttributes(Node oldNode, Node newNode) {
        int newLength;
        boolean oldHasAttributes = oldNode.hasAttributes();
        boolean newHasAttributes = newNode.hasAttributes();
        if (!oldHasAttributes && !newHasAttributes) {
            return true;
        }
        if (oldHasAttributes != newHasAttributes) {
            return false;
        }
        NamedNodeMap oldMap = oldNode.getAttributes();
        NamedNodeMap newMap = newNode.getAttributes();
        int oldLength = oldMap.getLength();
        if (oldLength != (newLength = newMap.getLength())) {
            return false;
        }
        Node newAttribute = null;
        Node oldAttribute = null;
        for (int i = 0; i < newLength; ++i) {
            newAttribute = newMap.item(i);
            oldAttribute = oldMap.getNamedItem(newAttribute.getNodeName());
            if (null == oldAttribute) {
                return false;
            }
            if (String.valueOf(oldAttribute.getNodeValue()).equals(String.valueOf(newAttribute.getNodeValue()))) continue;
            return false;
        }
        return true;
    }

    public static Element ascendToNodeWithID(Node node) {
        while (null != node) {
            String id;
            if (node instanceof Element && null != (id = ((Element)node).getAttribute("id")) && !"".equals(id)) {
                return (Element)node;
            }
            node = node.getParentNode();
        }
        return (Element)node;
    }

    public static boolean escapeIsRequired(UIComponent uiComponent) {
        Object escapeAttribute = uiComponent.getAttributes().get("escape");
        if (escapeAttribute != null) {
            if (escapeAttribute instanceof String) {
                return Boolean.valueOf((String)escapeAttribute);
            }
            if (escapeAttribute instanceof Boolean) {
                return (Boolean)escapeAttribute;
            }
        }
        return true;
    }

    public static String escapeAnsi(String text) {
        if (null == text) {
            return "";
        }
        char[] chars = text.toCharArray();
        StringBuffer buffer = new StringBuffer(chars.length);
        for (int index = 0; index < chars.length; ++index) {
            char ch = chars[index];
            if (ch <= '\u001f') {
                if (ch != '\t' && ch != '\n' && ch != '\r') continue;
                buffer.append(ch);
                continue;
            }
            if (ch == '\u007f') continue;
            if (ch == '>') {
                buffer.append("&gt;");
                continue;
            }
            if (ch == '<') {
                buffer.append("&lt;");
                continue;
            }
            if (ch == '&') {
                buffer.append("&amp;");
                continue;
            }
            if (ch == '\'') {
                buffer.append("&#39;");
                continue;
            }
            if (ch == '\"') {
                buffer.append("&quot;");
                continue;
            }
            if (ch >= '\u00a0' && ch <= '\u00ff') {
                buffer.append("&").append(DOMUtils.escapeAnsi(ch)).append(";");
                continue;
            }
            if (ch == '\u20ac') {
                buffer.append("&euro;");
                continue;
            }
            buffer.append(ch);
        }
        return buffer.toString();
    }

    private static String escapeAnsi(char character) {
        int indexOfEscapedCharacter = character - 160;
        return ansiCharacters[indexOfEscapedCharacter];
    }

    public static String toDebugString(Node node) {
        short type = node.getNodeType();
        switch (type) {
            case 2: {
                Attr attr = (Attr)node;
                return "attribute[name: " + attr.getName() + "; value: " + attr.getValue() + "]";
            }
            case 1: {
                Element element = (Element)node;
                StringBuffer buffer = new StringBuffer();
                buffer.append("element[tag: ");
                buffer.append(element.getTagName());
                buffer.append("; attributes: ");
                NamedNodeMap attributes = element.getAttributes();
                for (int i = 0; i < attributes.getLength(); ++i) {
                    Attr attr = (Attr)attributes.item(i);
                    buffer.append(attr.getName());
                    buffer.append("=");
                    buffer.append(attr.getValue());
                    buffer.append(' ');
                }
                buffer.append(']');
                return buffer.toString();
            }
            case 4: {
                CDATASection cdataSection = (CDATASection)node;
                return "cdata[" + cdataSection.getData() + "]";
            }
            case 3: {
                Text text = (Text)node;
                return "text[" + text.getData() + "]";
            }
            case 8: {
                Comment comment = (Comment)node;
                return "comment[" + comment.getData() + "]";
            }
            case 6: {
                Entity entity = (Entity)node;
                return "entity[public: " + entity.getPublicId() + "; system: " + entity.getSystemId() + "]";
            }
        }
        return node.getNodeName();
    }
}

