package de.dass_it.vanhelsing.gui;

import java.lang.reflect.Method;
import java.util.ArrayList;

import javax.faces.event.ActionEvent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import de.dass_it.vanhelsing.gui.items.*;
import de.dass_it.www.vanhelsing.*;
import de.dass_it.www.vanhelsing.VanHelsingCallbackHandler.*;
import de.dass_it.www.vanhelsing.VanHelsingStub.*;

/*
 * List all Bacula configuration components by name
 */
public class ConfigurationBean extends TreeNavigation {

	private DefaultTreeModel tree;
	private ArrayList<ViewItem> selectedObject;

	public ConfigurationBean(){
		DefaultMutableTreeNode root = new DefaultMutableTreeNode();
		DefaultMutableTreeNode header;
		DefaultMutableTreeNode leaf;
		String type;
		ListResourcesType lrt;
		GetResourceType grt;
		DefaultMutableTreeNode myNode;
		ResourceInfo[] ri;
		SimpleResource sr;
		((ClientItem)selectedObject).setName("ClientNameTest");
		
		Client c = new Client();
		//String[] nodes = {"Director", "Storage", "Catalog", "Autochanger", "Client", "FileSet", "FDClient", "Schedule", "SDStorage", "Console", "Catalog", "SDDevice", "Job", "JobDefs", "Messages", "Pool"};
		String[] nodes = {"Client"};
		setTree(super.createTree(root, nodes, "Configuration"));

		//\forall header wird eine ResourceList[] angefragt
		for(int i = 0; i < tree.getChildCount(root); i++){
			header = (DefaultMutableTreeNode)tree.getChild(root, i);
			type = ((UserObjectItemType)header.getUserObject()).getUserObject().getResType();
			lrt = new ListResourcesType();
			lrt.setDirector("bacula-dir");
			lrt.setResourceType(type);
			ri = c.getListResources(lrt);
			if (ri == null || ri.length == 0) continue;
			for (int j = 0; j < ri.length; j++){
				//myNode = null;
				myNode = addNode(header, type, ri[j]);
				if (myNode != null){
					header.add(myNode);
				}
			}
		}
		for (int i = 0; i < tree.getChildCount(root); i++){
			header = (DefaultMutableTreeNode)tree.getChild(root, i);
			
			for (int j = 0; j < tree.getChildCount(header); j++){
				leaf = (DefaultMutableTreeNode)tree.getChild(header, j);
				type = ((UserObjectItemType)leaf.getUserObject()).getUserObject().getResType();
				grt = new GetResourceType();
				grt.setDirector("bacula-dir");
				grt.setResId(((ItemType)(((UserObjectItemType)leaf.getUserObject()).getUserObject())).getResId());
				sr = c.getSimpleResource(grt);
				sr.getResourceAttributeType();
				myNode = addNode(leaf, type, sr.getResourceAttributeType());
				if (myNode != null){
					leaf.add(myNode);
				}

			}
		}
		

	}
	public void userObjectItemNodeSelected(ActionEvent ae){
		DefaultMutableTreeNode node;
		UserObjectItem userObject;
		String Id = BeanUtil.getRequestParameter("userObject.resId");
		node = getNode(Id, tree);
		String type = ((UserObjectItem)((UserObjectItemType)node.getUserObject()).getUserObject()).getResType();
		
	}
	
	public void setTree(DefaultTreeModel tree) {
		this.tree = tree;
	}
	public DefaultTreeModel getTree() {
		return tree;
	}
	public UserObjectItem getSelectedObject() {
		return selectedObject;
	}
	public void setSelectedObject(UserObjectItem selectedObject) {
		this.selectedObject = selectedObject;
	}
	
	
}
