/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanMetadataElement;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.security.util.UrlUtils;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public abstract class ConfigUtils {
    private static final Log logger = LogFactory.getLog((Class)(class$org$springframework$security$config$ConfigUtils == null ? (class$org$springframework$security$config$ConfigUtils = ConfigUtils.class$("org.springframework.security.config.ConfigUtils")) : class$org$springframework$security$config$ConfigUtils));
    static /* synthetic */ Class class$org$springframework$security$config$ConfigUtils;
    static /* synthetic */ Class class$org$springframework$security$vote$RoleVoter;
    static /* synthetic */ Class class$org$springframework$security$vote$AuthenticatedVoter;
    static /* synthetic */ Class class$org$springframework$security$vote$AffirmativeBased;
    static /* synthetic */ Class class$org$springframework$security$providers$ProviderManager;
    static /* synthetic */ Class class$org$springframework$security$afterinvocation$AfterInvocationProviderManager;
    static /* synthetic */ Class class$org$springframework$security$config$FilterChainProxyPostProcessor;
    static /* synthetic */ Class class$org$springframework$security$config$ConfigUtils$FilterChainList;

    static void registerDefaultAccessManagerIfNecessary(ParserContext parserContext) {
        if (!parserContext.getRegistry().containsBeanDefinition("_accessManager")) {
            ManagedList defaultVoters = new ManagedList(2);
            defaultVoters.add(new RootBeanDefinition(class$org$springframework$security$vote$RoleVoter == null ? (class$org$springframework$security$vote$RoleVoter = ConfigUtils.class$("org.springframework.security.vote.RoleVoter")) : class$org$springframework$security$vote$RoleVoter));
            defaultVoters.add(new RootBeanDefinition(class$org$springframework$security$vote$AuthenticatedVoter == null ? (class$org$springframework$security$vote$AuthenticatedVoter = ConfigUtils.class$("org.springframework.security.vote.AuthenticatedVoter")) : class$org$springframework$security$vote$AuthenticatedVoter));
            BeanDefinitionBuilder accessMgrBuilder = BeanDefinitionBuilder.rootBeanDefinition((Class)(class$org$springframework$security$vote$AffirmativeBased == null ? (class$org$springframework$security$vote$AffirmativeBased = ConfigUtils.class$("org.springframework.security.vote.AffirmativeBased")) : class$org$springframework$security$vote$AffirmativeBased));
            accessMgrBuilder.addPropertyValue("decisionVoters", (Object)defaultVoters);
            AbstractBeanDefinition accessMgr = accessMgrBuilder.getBeanDefinition();
            parserContext.getRegistry().registerBeanDefinition("_accessManager", (BeanDefinition)accessMgr);
        }
    }

    public static int countNonEmpty(String[] objects) {
        int nonNulls = 0;
        for (int i = 0; i < objects.length; ++i) {
            if (!StringUtils.hasText((String)objects[i])) continue;
            ++nonNulls;
        }
        return nonNulls;
    }

    public static void addVoter(BeanDefinition voter, ParserContext parserContext) {
        ConfigUtils.registerDefaultAccessManagerIfNecessary(parserContext);
        BeanDefinition accessMgr = parserContext.getRegistry().getBeanDefinition("_accessManager");
        ManagedList voters = (ManagedList)accessMgr.getPropertyValues().getPropertyValue("decisionVoters").getValue();
        voters.add(voter);
        accessMgr.getPropertyValues().addPropertyValue("decisionVoters", (Object)voters);
    }

    static BeanDefinition registerProviderManagerIfNecessary(ParserContext parserContext) {
        if (parserContext.getRegistry().containsBeanDefinition("_authenticationManager")) {
            return parserContext.getRegistry().getBeanDefinition("_authenticationManager");
        }
        RootBeanDefinition authManager = new RootBeanDefinition(class$org$springframework$security$providers$ProviderManager == null ? (class$org$springframework$security$providers$ProviderManager = ConfigUtils.class$("org.springframework.security.providers.ProviderManager")) : class$org$springframework$security$providers$ProviderManager);
        authManager.getPropertyValues().addPropertyValue("providers", (Object)new ManagedList());
        parserContext.getRegistry().registerBeanDefinition("_authenticationManager", (BeanDefinition)authManager);
        return authManager;
    }

    static ManagedList getRegisteredProviders(ParserContext parserContext) {
        BeanDefinition authManager = ConfigUtils.registerProviderManagerIfNecessary(parserContext);
        return (ManagedList)authManager.getPropertyValues().getPropertyValue("providers").getValue();
    }

    static ManagedList getRegisteredAfterInvocationProviders(ParserContext parserContext) {
        BeanDefinition manager = ConfigUtils.registerAfterInvocationProviderManagerIfNecessary(parserContext);
        return (ManagedList)manager.getPropertyValues().getPropertyValue("providers").getValue();
    }

    private static BeanDefinition registerAfterInvocationProviderManagerIfNecessary(ParserContext parserContext) {
        if (parserContext.getRegistry().containsBeanDefinition("_afterInvocationManager")) {
            return parserContext.getRegistry().getBeanDefinition("_afterInvocationManager");
        }
        RootBeanDefinition manager = new RootBeanDefinition(class$org$springframework$security$afterinvocation$AfterInvocationProviderManager == null ? (class$org$springframework$security$afterinvocation$AfterInvocationProviderManager = ConfigUtils.class$("org.springframework.security.afterinvocation.AfterInvocationProviderManager")) : class$org$springframework$security$afterinvocation$AfterInvocationProviderManager);
        manager.getPropertyValues().addPropertyValue("providers", (Object)new ManagedList());
        parserContext.getRegistry().registerBeanDefinition("_afterInvocationManager", (BeanDefinition)manager);
        return manager;
    }

    private static void registerFilterChainPostProcessorIfNecessary(ParserContext pc) {
        if (pc.getRegistry().containsBeanDefinition("_filterChainProxyPostProcessor")) {
            return;
        }
        RootBeanDefinition filterChainPostProcessor = new RootBeanDefinition(class$org$springframework$security$config$FilterChainProxyPostProcessor == null ? (class$org$springframework$security$config$FilterChainProxyPostProcessor = ConfigUtils.class$("org.springframework.security.config.FilterChainProxyPostProcessor")) : class$org$springframework$security$config$FilterChainProxyPostProcessor);
        filterChainPostProcessor.setRole(2);
        pc.getRegistry().registerBeanDefinition("_filterChainProxyPostProcessor", (BeanDefinition)filterChainPostProcessor);
        RootBeanDefinition filterList = new RootBeanDefinition(class$org$springframework$security$config$ConfigUtils$FilterChainList == null ? (class$org$springframework$security$config$ConfigUtils$FilterChainList = ConfigUtils.class$("org.springframework.security.config.ConfigUtils$FilterChainList")) : class$org$springframework$security$config$ConfigUtils$FilterChainList);
        filterList.setRole(2);
        pc.getRegistry().registerBeanDefinition("_filterChainList", (BeanDefinition)filterList);
    }

    static void addHttpFilter(ParserContext pc, BeanMetadataElement filter) {
        ManagedList filters;
        ConfigUtils.registerFilterChainPostProcessorIfNecessary(pc);
        RootBeanDefinition filterList = (RootBeanDefinition)pc.getRegistry().getBeanDefinition("_filterChainList");
        MutablePropertyValues pvs = filterList.getPropertyValues();
        if (pvs.contains("filters")) {
            filters = (ManagedList)pvs.getPropertyValue("filters").getValue();
        } else {
            filters = new ManagedList();
            pvs.addPropertyValue("filters", (Object)filters);
        }
        filters.add(filter);
    }

    static void validateHttpRedirect(String url, ParserContext pc, Object source) {
        if (UrlUtils.isValidRedirectUrl(url) || url.startsWith("$")) {
            return;
        }
        pc.getReaderContext().warning(url + " is not a valid redirect URL (must start with '/' or http(s))", source);
    }

    static void setSessionControllerOnAuthenticationManager(ParserContext pc, String beanName, Element sourceElt) {
        BeanDefinition authManager = ConfigUtils.registerProviderManagerIfNecessary(pc);
        PropertyValue pv = authManager.getPropertyValues().getPropertyValue("sessionController");
        if (pv != null && pv.getValue() != null) {
            pc.getReaderContext().error("A session controller has already been set on the authentication manager. The <concurrent-session-control> element isn't compatible with a custom session controller", pc.extractSource((Object)sourceElt));
        }
        authManager.getPropertyValues().addPropertyValue("sessionController", (Object)new RuntimeBeanReference(beanName));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class FilterChainList {
        List filters;

        public List getFilters() {
            return this.filters;
        }

        public void setFilters(List filters) {
            this.filters = filters;
        }
    }
}

