/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.push.server;

import com.icesoft.net.messaging.AbstractMessageHandler;
import com.icesoft.net.messaging.Message;
import com.icesoft.net.messaging.MessageHandler;
import com.icesoft.net.messaging.MessageSelector;
import com.icesoft.net.messaging.TextMessage;
import com.icesoft.net.messaging.expression.And;
import com.icesoft.net.messaging.expression.Container;
import com.icesoft.net.messaging.expression.Equal;
import com.icesoft.net.messaging.expression.Expression;
import com.icesoft.net.messaging.expression.Identifier;
import com.icesoft.net.messaging.expression.IsNull;
import com.icesoft.net.messaging.expression.Literal;
import com.icesoft.net.messaging.expression.Or;
import com.icesoft.net.messaging.expression.StringLiteral;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.icefaces.push.server.UpdatedViews;

public class UpdatedViewsMessageHandler
extends AbstractMessageHandler
implements MessageHandler {
    protected static final String MESSAGE_TYPE = "UpdatedViews";
    private static final Log LOG = LogFactory.getLog((Class)UpdatedViewsMessageHandler.class);
    private static MessageSelector messageSelector;

    public UpdatedViewsMessageHandler() {
        super(messageSelector);
    }

    public void handle(Message message) {
        if (message == null) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Handling:\r\n\r\n" + message));
        }
        if (message instanceof TextMessage) {
            String _messageBody = ((TextMessage)message).getText();
            int _beginIndex = 0;
            int _endIndex = _messageBody.indexOf(";");
            String _iceFacesId = _messageBody.substring(_beginIndex, _endIndex);
            _beginIndex = _endIndex + 1;
            _endIndex = _messageBody.indexOf(";", _beginIndex);
            long _sequenceNumber = Long.parseLong(_messageBody.substring(_beginIndex, _endIndex));
            _beginIndex = _endIndex + 1;
            StringTokenizer _tokens = new StringTokenizer(_messageBody.substring(_beginIndex), ",");
            int _tokenCount = _tokens.countTokens();
            HashSet<String> _updatedViewsSet = new HashSet<String>(_tokenCount);
            for (int i = 0; i < _tokenCount; ++i) {
                _updatedViewsSet.add(_tokens.nextToken());
            }
            MessageHandler.Callback[] _callbacks = this.getCallbacks(message);
            for (int i = 0; i < _callbacks.length; ++i) {
                ((Callback)_callbacks[i]).sendUpdatedViews(new UpdatedViews(_iceFacesId, _sequenceNumber, _updatedViewsSet));
            }
        }
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getName();
    }

    static {
        try {
            messageSelector = new MessageSelector((Expression)new And((Expression)new Equal(new Identifier("message_type"), (Literal)new StringLiteral(MESSAGE_TYPE)), (Expression)new Container((Expression)new Or((Expression)new IsNull(new Identifier("destination_nodeAddress")), (Expression)new Equal(new Identifier("destination_nodeAddress"), (Literal)new StringLiteral(InetAddress.getLocalHost().getHostAddress()))))));
        }
        catch (UnknownHostException exception) {
            if (LOG.isFatalEnabled()) {
                LOG.fatal((Object)"Failed to get IP address for localhost!", (Throwable)exception);
            }
            messageSelector = null;
        }
    }

    public static interface Callback
    extends MessageHandler.Callback {
        public void sendUpdatedViews(UpdatedViews var1);
    }
}

