/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.shared_impl.webapp.webxml;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.context.ExternalContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.shared_impl.util.ClassUtils;
import org.apache.myfaces.shared_impl.webapp.webxml.FilterMapping;
import org.apache.myfaces.shared_impl.webapp.webxml.ServletMapping;
import org.apache.myfaces.shared_impl.webapp.webxml.WebXmlParser;

public class WebXml {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$myfaces$shared_impl$webapp$webxml$WebXmlParser == null ? (class$org$apache$myfaces$shared_impl$webapp$webxml$WebXmlParser = WebXml.class$("org.apache.myfaces.shared_impl.webapp.webxml.WebXmlParser")) : class$org$apache$myfaces$shared_impl$webapp$webxml$WebXmlParser));
    private Map _servlets = new HashMap();
    private Map _servletMappings = new HashMap();
    private Map _filters = new HashMap();
    private Map _filterMappings = new HashMap();
    private List _facesServletMappings = null;
    private List _facesExtensionsFilterMappings = null;
    private static final String WEB_XML_ATTR = (class$org$apache$myfaces$shared_impl$webapp$webxml$WebXml == null ? (class$org$apache$myfaces$shared_impl$webapp$webxml$WebXml = WebXml.class$("org.apache.myfaces.shared_impl.webapp.webxml.WebXml")) : class$org$apache$myfaces$shared_impl$webapp$webxml$WebXml).getName();
    static /* synthetic */ Class class$org$apache$myfaces$shared_impl$webapp$webxml$WebXmlParser;
    static /* synthetic */ Class class$org$apache$myfaces$shared_impl$webapp$webxml$WebXml;

    void addServlet(String servletName, String servletClass) {
        if (this._servlets.get(servletName) != null) {
            log.warn((Object)("Servlet " + servletName + " defined more than once, first definition will be used."));
        } else {
            this._servlets.put(servletName, servletClass);
        }
    }

    void addFilter(String filterName, String filterClass) {
        if (this._filters.get(filterName) != null) {
            log.warn((Object)("Filter " + filterName + " defined more than once, first definition will be used."));
        } else {
            this._filters.put(filterName, filterClass);
        }
    }

    boolean containsServlet(String servletName) {
        return this._servlets.containsKey(servletName);
    }

    boolean containsFilter(String filterName) {
        return this._filters.containsKey(filterName);
    }

    void addServletMapping(String servletName, String urlPattern) {
        ArrayList<String> mappings = (ArrayList<String>)this._servletMappings.get(servletName);
        if (mappings == null) {
            mappings = new ArrayList<String>();
            this._servletMappings.put(servletName, mappings);
        }
        mappings.add(urlPattern);
    }

    void addFilterMapping(String filterName, String urlPattern) {
        ArrayList<String> mappings = (ArrayList<String>)this._filterMappings.get(filterName);
        if (mappings == null) {
            mappings = new ArrayList<String>();
            this._filterMappings.put(filterName, mappings);
        }
        mappings.add(urlPattern);
    }

    public List getFacesServletMappings() {
        if (this._facesServletMappings != null) {
            return this._facesServletMappings;
        }
        this._facesServletMappings = new ArrayList();
        Iterator it = this._servlets.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String servletName = (String)entry.getKey();
            if (null == entry.getValue()) continue;
            Class servletClass = ClassUtils.simpleClassForName((String)entry.getValue());
            List urlPatterns = (List)this._servletMappings.get(servletName);
            if (urlPatterns == null) continue;
            Iterator it2 = urlPatterns.iterator();
            while (it2.hasNext()) {
                String urlpattern = (String)it2.next();
                this._facesServletMappings.add(new ServletMapping(servletName, servletClass, urlpattern));
                if (!log.isTraceEnabled()) continue;
                log.trace((Object)("adding mapping for servlet + " + servletName + " urlpattern = " + urlpattern));
            }
        }
        return this._facesServletMappings;
    }

    public List getFacesExtensionsFilterMappings() {
        if (this._facesExtensionsFilterMappings != null) {
            return this._facesExtensionsFilterMappings;
        }
        this._facesExtensionsFilterMappings = new ArrayList();
        Iterator it = this._filters.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String filterName = (String)entry.getKey();
            String filterClassName = (String)entry.getValue();
            if (!"org.apache.myfaces.component.html.util.ExtensionsFilter".equals(filterClassName) && !"org.apache.myfaces.webapp.filter.ExtensionsFilter".equals(filterClassName)) continue;
            Class filterClass = ClassUtils.simpleClassForName(filterClassName);
            List urlPatterns = (List)this._filterMappings.get(filterName);
            if (urlPatterns == null) continue;
            Iterator it2 = urlPatterns.iterator();
            while (it2.hasNext()) {
                String urlpattern = (String)it2.next();
                this._facesExtensionsFilterMappings.add(new FilterMapping(filterName, filterClass, urlpattern));
                if (!log.isTraceEnabled()) continue;
                log.trace((Object)("adding mapping for filter + " + filterName + " urlpattern = " + urlpattern));
            }
        }
        return this._facesExtensionsFilterMappings;
    }

    public static WebXml getWebXml(ExternalContext context) {
        WebXml webXml = (WebXml)context.getApplicationMap().get(WEB_XML_ATTR);
        if (webXml == null) {
            WebXml.init(context);
            webXml = (WebXml)context.getApplicationMap().get(WEB_XML_ATTR);
        }
        return webXml;
    }

    public static void init(ExternalContext context) {
        WebXmlParser parser = new WebXmlParser(context);
        WebXml webXml = parser.parse();
        context.getApplicationMap().put(WEB_XML_ATTR, webXml);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

