/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.runtime.impl;

public class StringIntHashMap {
    public static final int DEFAULT_NOT_FOUND = Integer.MIN_VALUE;
    protected static final double DEFAULT_FILL = 0.3;
    protected static final int MINIMUM_SIZE = 31;
    protected final double m_fillFraction;
    protected int m_entryCount;
    protected int m_entryLimit;
    protected int m_arraySize;
    protected int m_hitOffset;
    protected String[] m_keyTable;
    protected int[] m_valueTable;
    protected int m_notFoundValue;

    public StringIntHashMap(int count, double fill, int miss) {
        if (fill <= 0.0 || fill >= 1.0) {
            throw new IllegalArgumentException("fill value out of range");
        }
        this.m_fillFraction = fill;
        this.m_arraySize = Math.max((int)((double)count / this.m_fillFraction), 31);
        this.m_arraySize += (this.m_arraySize + 1) % 2;
        this.m_entryLimit = (int)((double)this.m_arraySize * this.m_fillFraction);
        this.m_hitOffset = this.m_arraySize / 2;
        this.m_keyTable = new String[this.m_arraySize];
        this.m_valueTable = new int[this.m_arraySize];
        this.m_notFoundValue = miss;
    }

    public StringIntHashMap(int count, double fill) {
        this(count, fill, Integer.MIN_VALUE);
    }

    public StringIntHashMap(int count) {
        this(count, 0.3);
    }

    public StringIntHashMap() {
        this(0, 0.3);
    }

    public StringIntHashMap(StringIntHashMap base) {
        this.m_fillFraction = base.m_fillFraction;
        this.m_entryCount = base.m_entryCount;
        this.m_entryLimit = base.m_entryLimit;
        this.m_arraySize = base.m_arraySize;
        this.m_hitOffset = base.m_hitOffset;
        this.m_notFoundValue = base.m_notFoundValue;
        this.m_keyTable = new String[this.m_arraySize];
        System.arraycopy(base.m_keyTable, 0, this.m_keyTable, 0, this.m_arraySize);
        this.m_valueTable = new int[this.m_arraySize];
        System.arraycopy(base.m_valueTable, 0, this.m_valueTable, 0, this.m_arraySize);
    }

    private final int stepSlot(int slot) {
        return (slot + this.m_hitOffset) % this.m_arraySize;
    }

    private final int freeSlot(int slot) {
        while (this.m_keyTable[slot] != null) {
            slot = this.stepSlot(slot);
        }
        return slot;
    }

    private final int standardSlot(Object key) {
        return (key.hashCode() & Integer.MAX_VALUE) % this.m_arraySize;
    }

    private int standardFind(Object key) {
        int slot = this.standardSlot(key);
        while (this.m_keyTable[slot] != null) {
            if (this.m_keyTable[slot].equals(key)) {
                return slot;
            }
            slot = this.stepSlot(slot);
        }
        return -slot - 1;
    }

    private boolean reinsert(int slot) {
        String key = this.m_keyTable[slot];
        this.m_keyTable[slot] = null;
        return this.assignSlot(key, this.m_valueTable[slot]) != slot;
    }

    protected void internalRemove(int slot) {
        this.m_keyTable[slot] = null;
        --this.m_entryCount;
        while (this.m_keyTable[slot = this.stepSlot(slot)] != null) {
            this.reinsert(slot);
        }
    }

    private void restructure(String[] keys, int[] values) {
        for (int i = 0; i < keys.length; ++i) {
            if (keys[i] == null) continue;
            this.assignSlot(keys[i], values[i]);
        }
    }

    private int assignSlot(String key, int value) {
        int offset = this.freeSlot(this.standardSlot(key));
        this.m_keyTable[offset] = key;
        this.m_valueTable[offset] = value;
        return offset;
    }

    public int add(String key, int value) {
        int offset;
        if (key == null) {
            throw new IllegalArgumentException("null key not supported");
        }
        if (value == this.m_notFoundValue) {
            throw new IllegalArgumentException("value matching not found return not supported");
        }
        int min = this.m_entryCount + 1;
        if (min > this.m_entryLimit) {
            int size = this.m_arraySize;
            int limit = this.m_entryLimit;
            while (limit < min) {
                size = size * 2 + 1;
                limit = (int)((double)size * this.m_fillFraction);
            }
            this.m_arraySize = size;
            this.m_entryLimit = limit;
            this.m_hitOffset = size / 2;
            String[] keys = this.m_keyTable;
            this.m_keyTable = new String[this.m_arraySize];
            int[] values = this.m_valueTable;
            this.m_valueTable = new int[this.m_arraySize];
            this.restructure(keys, values);
        }
        if ((offset = this.standardFind(key)) >= 0) {
            int prior = this.m_valueTable[offset];
            this.m_valueTable[offset] = value;
            return prior;
        }
        ++this.m_entryCount;
        offset = -offset - 1;
        this.m_keyTable[offset] = key;
        this.m_valueTable[offset] = value;
        return this.m_notFoundValue;
    }

    public final boolean containsKey(String key) {
        return this.standardFind(key) >= 0;
    }

    public final int get(String key) {
        int slot = this.standardFind(key);
        if (slot >= 0) {
            return this.m_valueTable[slot];
        }
        return this.m_notFoundValue;
    }

    public int remove(String key) {
        int slot = this.standardFind(key);
        if (slot >= 0) {
            int value = this.m_valueTable[slot];
            this.internalRemove(slot);
            return value;
        }
        return this.m_notFoundValue;
    }

    public Object clone() {
        return new StringIntHashMap(this);
    }
}

