/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.clustering.tribes;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.axis2.clustering.LoadBalanceEventHandler;
import org.apache.axis2.clustering.control.wka.MemberJoinedCommand;
import org.apache.axis2.clustering.control.wka.MemberListCommand;
import org.apache.axis2.clustering.tribes.TribesUtil;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.catalina.tribes.Member;
import org.apache.catalina.tribes.RemoteProcessException;
import org.apache.catalina.tribes.group.Response;
import org.apache.catalina.tribes.group.RpcChannel;
import org.apache.catalina.tribes.group.interceptors.StaticMembershipInterceptor;
import org.apache.catalina.tribes.membership.MemberImpl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MembershipManager {
    private static final Log log = LogFactory.getLog(MembershipManager.class);
    private RpcChannel rpcMembershipChannel;
    private StaticMembershipInterceptor staticMembershipInterceptor;
    private byte[] domain;
    private LoadBalanceEventHandler loadBalanceEventHandler;
    private ConfigurationContext configContext;
    private final List<Member> members = new ArrayList<Member>();
    private List<Member> wkaMembers = new ArrayList<Member>();
    private Member localMember;

    public MembershipManager(ConfigurationContext configContext) {
        this.configContext = configContext;
    }

    public MembershipManager() {
    }

    public void setRpcMembershipChannel(RpcChannel rpcMembershipChannel) {
        this.rpcMembershipChannel = rpcMembershipChannel;
    }

    public RpcChannel getRpcMembershipChannel() {
        return this.rpcMembershipChannel;
    }

    public void setStaticMembershipInterceptor(StaticMembershipInterceptor staticMembershipInterceptor) {
        this.staticMembershipInterceptor = staticMembershipInterceptor;
    }

    public void setLoadBalanceEventHandler(LoadBalanceEventHandler loadBalanceEventHandler) {
        this.loadBalanceEventHandler = loadBalanceEventHandler;
    }

    public void setDomain(byte[] domain) {
        this.domain = domain;
    }

    public byte[] getDomain() {
        return this.domain;
    }

    public Member getLocalMember() {
        return this.localMember;
    }

    public void setLocalMember(Member localMember) {
        this.localMember = localMember;
    }

    public void addWellKnownMember(Member wkaMember) {
        this.wkaMembers.add(wkaMember);
    }

    public void removeWellKnownMember(Member wkaMember) {
        this.wkaMembers.remove(wkaMember);
    }

    public synchronized boolean memberAdded(Member member) {
        boolean shouldAddMember;
        if (log.isDebugEnabled()) {
            log.debug((Object)("members.contains(member) =" + this.members.contains(member)));
            log.debug((Object)("Is in my domain: " + TribesUtil.isInDomain(member, this.domain)));
        }
        if (this.members.contains(member) || !TribesUtil.isInDomain(member, this.domain)) {
            return false;
        }
        if (this.staticMembershipInterceptor != null) {
            this.staticMembershipInterceptor.addStaticMember(member);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Added static member " + TribesUtil.getName(member)));
            }
        }
        boolean bl = shouldAddMember = this.localMember == null || TribesUtil.areInSameDomain(this.localMember, member);
        if (this.loadBalanceEventHandler != null) {
            log.info((Object)("Application member " + TribesUtil.getName(member) + " joined group " + new String(member.getDomain())));
            this.loadBalanceEventHandler.applicationMemberAdded(TribesUtil.toAxis2Member(member));
        }
        if (shouldAddMember) {
            if (this.rpcMembershipChannel != null && this.isLocalMemberInitialized() && this.wkaMembers.contains(member)) {
                log.info((Object)("A WKA member " + TribesUtil.getName(member) + " just joined the group. Sending MEMBER_LIST message."));
                try {
                    Member source;
                    MemberListCommand memListCmd = new MemberListCommand();
                    ArrayList<Member> members = new ArrayList<Member>(this.members);
                    members.add(this.localMember);
                    memListCmd.setMembers(members.toArray(new Member[members.size()]));
                    Response[] responses = this.rpcMembershipChannel.send(new Member[]{member}, (Serializable)((Object)memListCmd), 3, 1032, 10000L);
                    if (responses != null && responses.length > 0 && responses[0] != null && !TribesUtil.areInSameDomain(source = responses[0].getSource(), member)) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("WKA Member " + TribesUtil.getName(source) + " does not belong to local domain " + new String(this.domain) + ". Hence removing it from the list."));
                        }
                        members.remove(member);
                        return false;
                    }
                }
                catch (Exception e) {
                    String errMsg = "Could not send MEMBER_LIST to well-known member " + TribesUtil.getName(member);
                    log.error((Object)errMsg, (Throwable)e);
                    throw new RemoteProcessException(errMsg, (Throwable)e);
                }
            }
            this.members.add(member);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Added group member " + TribesUtil.getName(member) + " to domain " + new String(member.getDomain())));
            }
            return true;
        }
        return false;
    }

    public void sendMemberList(Member member) {
        try {
            MemberListCommand memListCmd = new MemberListCommand();
            ArrayList<Member> members = new ArrayList<Member>(this.members);
            memListCmd.setMembers(members.toArray(new Member[members.size()]));
            this.rpcMembershipChannel.send(new Member[]{member}, (Serializable)((Object)memListCmd), 3, 1032, 10000L);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Sent MEMBER_LIST to " + TribesUtil.getName(member)));
            }
        }
        catch (Exception e) {
            String errMsg = "Could not send MEMBER_LIST to member " + TribesUtil.getName(member);
            log.error((Object)errMsg, (Throwable)e);
            throw new RemoteProcessException(errMsg, (Throwable)e);
        }
    }

    public void sendMemberJoinedToAll(Member member) {
        try {
            MemberJoinedCommand cmd = new MemberJoinedCommand();
            cmd.setMember(member);
            ArrayList membersToSend = (ArrayList)((ArrayList)this.members).clone();
            membersToSend.remove(member);
            if (membersToSend.size() > 0) {
                this.rpcMembershipChannel.send(membersToSend.toArray(new Member[membersToSend.size()]), (Serializable)((Object)cmd), 3, 1032, 10000L);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Sent MEMBER_JOINED[" + TribesUtil.getName(member) + "] to all members in domain " + new String(this.domain)));
                }
            }
        }
        catch (Exception e) {
            String errMsg = "Could not send MEMBER_JOINED[" + TribesUtil.getName(member) + "] to all members ";
            log.error((Object)errMsg, (Throwable)e);
            throw new RemoteProcessException(errMsg, (Throwable)e);
        }
    }

    private boolean isLocalMemberInitialized() {
        if (this.configContext == null) {
            return false;
        }
        Object clusterInitialized = this.configContext.getPropertyNonReplicable("local_cluster.initialized");
        return clusterInitialized != null && clusterInitialized.equals("true");
    }

    public synchronized void memberDisappeared(Member member) {
        this.members.remove(member);
        if (this.loadBalanceEventHandler != null) {
            this.loadBalanceEventHandler.applicationMemberRemoved(TribesUtil.toAxis2Member(member));
        }
    }

    public synchronized Member[] getMembers() {
        return this.members.toArray(new Member[this.members.size()]);
    }

    public synchronized Member getLongestLivingMember() {
        Member longestLivingMember = null;
        if (this.members.size() > 0) {
            Member member0 = this.members.get(0);
            long longestAliveTime = member0.getMemberAliveTime();
            longestLivingMember = member0;
            for (Member member : this.members) {
                if (longestAliveTime >= member.getMemberAliveTime()) continue;
                longestAliveTime = member.getMemberAliveTime();
                longestLivingMember = member;
            }
        }
        return longestLivingMember;
    }

    public synchronized Member getRandomMember() {
        if (this.members.size() == 0) {
            return null;
        }
        int memberIndex = new Random().nextInt(this.members.size());
        return this.members.get(memberIndex);
    }

    public boolean hasMembers() {
        return this.members.size() > 0;
    }

    public Member getMember(Member member) {
        if (this.hasMembers()) {
            MemberImpl result = null;
            for (int i = 0; i < this.members.size() && result == null; ++i) {
                if (!this.members.get(i).equals(member)) continue;
                result = (MemberImpl)this.members.get(i);
            }
            return result;
        }
        return null;
    }
}

