/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public abstract class HolderBase {
    private final String m_namespace;
    private final Map m_nsPrefixMap;
    private String m_fileName;
    private Set m_referenceSet;

    public HolderBase(String uri) {
        this.m_namespace = uri;
        this.m_nsPrefixMap = new HashMap();
        if (uri != null) {
            this.m_nsPrefixMap.put(uri, "tns");
        }
    }

    public String getPrefix(String uri) {
        if (uri == null) {
            return "";
        }
        String prefix = (String)this.m_nsPrefixMap.get(uri);
        if (prefix == null) {
            prefix = "ns" + this.m_nsPrefixMap.size();
            this.m_nsPrefixMap.put(uri, prefix);
            this.addNamespaceDecl(prefix, uri);
        }
        return prefix;
    }

    protected abstract void addNamespaceDecl(String var1, String var2);

    public String getNamespace() {
        return this.m_namespace;
    }

    public String getFileName() {
        return this.m_fileName;
    }

    public void setFileName(String name) {
        this.m_fileName = name;
    }

    public void addReference(HolderBase ref) {
        if (ref == null) {
            throw new IllegalArgumentException("Reference cannot be to null");
        }
        if (this.m_referenceSet == null) {
            this.m_referenceSet = new HashSet();
        }
        this.m_referenceSet.add(ref);
    }

    public Set getReferences() {
        if (this.m_referenceSet == null) {
            return Collections.EMPTY_SET;
        }
        return this.m_referenceSet;
    }

    public abstract void finish();
}

