/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.server.config;

import javax.xml.ws.soap.Addressing;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.addressing.SubmissionAddressing;
import org.apache.axis2.jaxws.description.EndpointDescription;
import org.apache.axis2.jaxws.description.EndpointDescriptionJava;
import org.apache.axis2.jaxws.description.ServiceDescription;
import org.apache.axis2.jaxws.feature.ServerConfigurator;
import org.apache.axis2.jaxws.i18n.Messages;
import org.apache.axis2.jaxws.registry.ServerConfiguratorRegistry;
import org.apache.axis2.util.JavaUtils;
import org.apache.axis2.util.Utils;

public class AddressingConfigurator
implements ServerConfigurator {
    public void configure(EndpointDescription endpointDescription) {
        boolean w3cAddressingEnabled;
        Addressing addressing = (Addressing)((EndpointDescriptionJava)((Object)endpointDescription)).getAnnoFeature("http://www.w3.org/2005/08/addressing/module");
        SubmissionAddressing submissionAddressing = (SubmissionAddressing)((EndpointDescriptionJava)((Object)endpointDescription)).getAnnoFeature("http://schemas.xmlsoap.org/ws/2004/08/addressing");
        Parameter namespace = new Parameter("WSAddressingVersion", null);
        Parameter disabled = new Parameter("disableAddressingForInMessages", (Object)"false");
        Parameter required = new Parameter("addressingRequirementParameter", (Object)"unspecified");
        if (addressing != null && submissionAddressing != null) {
            w3cAddressingEnabled = addressing.enabled();
            boolean submissionAddressingEnabled = submissionAddressing.enabled();
            if (w3cAddressingEnabled && submissionAddressingEnabled) {
                namespace.setValue(null);
                boolean w3cAddressingRequired = addressing.required();
                boolean submissionAddressingRequired = submissionAddressing.required();
                if (w3cAddressingRequired || submissionAddressingRequired) {
                    required.setValue((Object)"required");
                }
            } else if (w3cAddressingEnabled) {
                namespace.setValue((Object)"http://www.w3.org/2005/08/addressing");
                if (addressing.required()) {
                    required.setValue((Object)"required");
                }
            } else if (submissionAddressingEnabled) {
                namespace.setValue((Object)"http://schemas.xmlsoap.org/ws/2004/08/addressing");
                if (submissionAddressing.required()) {
                    required.setValue((Object)"required");
                }
            } else {
                disabled.setValue((Object)"true");
            }
        } else if (addressing != null) {
            w3cAddressingEnabled = addressing.enabled();
            if (w3cAddressingEnabled) {
                namespace.setValue((Object)"http://www.w3.org/2005/08/addressing");
                if (addressing.required()) {
                    required.setValue((Object)"required");
                }
            } else {
                namespace.setValue((Object)"http://schemas.xmlsoap.org/ws/2004/08/addressing");
            }
        } else if (submissionAddressing != null) {
            boolean submissionAddressingEnabled = submissionAddressing.enabled();
            if (submissionAddressingEnabled) {
                namespace.setValue((Object)"http://schemas.xmlsoap.org/ws/2004/08/addressing");
                if (submissionAddressing.required()) {
                    required.setValue((Object)"required");
                }
            } else {
                namespace.setValue((Object)"http://www.w3.org/2005/08/addressing");
            }
        } else {
            throw ExceptionFactory.makeWebServiceException(Messages.getMessage("NoWSAddressingFeatures"));
        }
        try {
            ServiceDescription sd;
            AxisConfiguration axisConfig;
            AxisService service = endpointDescription.getAxisService();
            service.addParameter(namespace);
            service.addParameter(disabled);
            service.addParameter(required);
            String value = Utils.getParameterValue((Parameter)disabled);
            if (JavaUtils.isFalseExplicitly((String)value) && !(axisConfig = (sd = endpointDescription.getServiceDescription()).getAxisConfigContext().getAxisConfiguration()).isEngaged("addressing")) {
                axisConfig.engageModule("addressing");
            }
        }
        catch (Exception e) {
            throw ExceptionFactory.makeWebServiceException(Messages.getMessage("AddressingEngagementError", e.toString()));
        }
    }

    public boolean supports(String bindingId) {
        return ServerConfiguratorRegistry.isSOAPBinding(bindingId);
    }
}

