package de.dass_it.vanhelsing.gui;

import javax.faces.model.SelectItem;
import de.dass_it.vanhelsing.gui.items.ItemType;
import de.dass_it.vanhelsing.gui.items.UserObjectItem;
/**
 * The class ViewItem is used for the visualization of a SimpleResource object.
 * Rendered SimpleResources are ArrayLists of ViewItem objects.
 * @author tgoecke
 *
 */
public class ViewItem extends ItemType implements UserObjectItem {
	private String key;
	private String keyValue;
	private boolean required;
	private String renderer;
	private String dataType;
	private SelectItem[] keyValueList;

	private boolean inputText;
	private boolean selectOneMenu;
	private boolean radioGroup;
	public ViewItem(){
		inputText = false;
		selectOneMenu = false;
		radioGroup = false;
	}
	
	public boolean getRequired() {
		return required;
	}

	public void setRequired(boolean required) {
		this.required = required;
	}

	public String getRenderer() {
		return renderer;
	}

	public String getDataType() {
		return dataType;
	}

	public void setDataType(String dataType) {
		this.dataType = dataType;
	}

	
	public int getResId(){
		return super.getResId();
	}
	public void setResId(int id){
		super.setResId(id);
	}
	public String getResType(){
		return super.getResType();
	}
	public void setResType(String resType){
		super.setResType(resType);
	}
	//eigene Felder für die Tabellenspalten
	public void setKey(String key) {
		this.key = key;
	}

	public String getKey() {
		return key;
	}
	
	public String getKeyValue() {
		return keyValue;
	}

	public void setKeyValue(String keyValue) {
		this.keyValue = keyValue;
	}

	public void setInputText(boolean inputText) {
		this.inputText = inputText;
	}

	public boolean getInputText() {
		return inputText;
	}

	public void setSelectOneMenu(boolean selectOneMenu) {
		this.selectOneMenu = selectOneMenu;
	}

	public boolean getSelectOneMenu() {
		return selectOneMenu;
	}
	public boolean getRadioGroup(){
		return radioGroup;
	}
	public void setRadioGroup(boolean radioGroup){
		this.radioGroup = radioGroup;
	}
	/**
	 * Set the string property of the intended render type to the value of the none empty string "bernd"
	 * @param r valid inputs are inputText, selectOneMenu and radioGroup 
	 */
	public void setRenderer(String r){
		if (r.equals("inputText")) {
			this.inputText = true;
		}
		if (r.equals("selectOneMenu")){
			this.selectOneMenu = true; //null;
		}
		if (r.equals("radioGroup")){
			this.radioGroup = true;
		}
		this.renderer = r;
	}
	/**
	 * Key-Value-Pairs for the SelectOneMenu
	 * @return an array of key value pairs as an SelectItem object array
	 */
	public SelectItem[] getKeyValueList() {
		return keyValueList;
	}
	/**
	 * 
	 * @param keyValueList
	 */
	public void setKeyValueList(SelectItem[] keyValueList) {
		this.keyValueList = keyValueList;
	}
}
