/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.util;

import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;

public class XSLTTemplateProcessor {
    public static void parse(OutputStream out, InputStream xmlStream, InputStream xsltStream) throws TransformerFactoryConfigurationError, TransformerException {
        StreamSource xmlSource = new StreamSource(xmlStream);
        StreamSource xsltSource = new StreamSource(xsltStream);
        StreamResult result = new StreamResult(out);
        Transformer transformer = TransformerFactory.newInstance().newTransformer(xsltSource);
        transformer.transform(xmlSource, result);
    }

    public static void parse(OutputStream out, Document doc, Transformer transformer) throws TransformerFactoryConfigurationError, TransformerException {
        DOMSource xmlSource = new DOMSource(doc);
        StreamResult result = new StreamResult(out);
        transformer.transform(xmlSource, result);
    }

    public static void parse(OutputStream out, Document document, InputStream xsltStream) throws TransformerFactoryConfigurationError, TransformerException {
        StreamSource xsltSource = new StreamSource(xsltStream);
        Transformer transformer = TransformerFactory.newInstance().newTransformer(xsltSource);
        XSLTTemplateProcessor.parse(out, document, transformer);
    }

    public static void parse(OutputStream out, Document document, InputStream xsltStream, URIResolver customResolver) throws TransformerFactoryConfigurationError, TransformerException {
        XSLTTemplateProcessor.parse(out, document, xsltStream, customResolver, false);
    }

    public static void parse(OutputStream out, Document document, InputStream xsltStream, URIResolver customResolver, boolean pretty) throws TransformerFactoryConfigurationError, TransformerException {
        StreamSource xsltSource = new StreamSource(xsltStream);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        if (pretty) {
            try {
                transformerFactory.setAttribute("indent-number", new Integer(2));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (customResolver != null) {
            transformerFactory.setURIResolver(customResolver);
        }
        Transformer transformer = transformerFactory.newTransformer(xsltSource);
        if (pretty) {
            try {
                transformer.setOutputProperty("{http://xml.apache.org/xalan}indent-amount", "2");
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        XSLTTemplateProcessor.parse(out, document, transformer);
    }
}

