/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.handler;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPMessage;
import javax.xml.stream.XMLStreamException;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import org.apache.axiom.soap.RolePlayer;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.core.MessageContext;
import org.apache.axis2.jaxws.handler.BaseMessageContext;
import org.apache.axis2.jaxws.i18n.Messages;
import org.apache.axis2.jaxws.message.Block;
import org.apache.axis2.jaxws.message.Message;
import org.apache.axis2.jaxws.message.databinding.JAXBBlockContext;
import org.apache.axis2.jaxws.message.factory.JAXBBlockFactory;
import org.apache.axis2.jaxws.message.factory.MessageFactory;
import org.apache.axis2.jaxws.registry.FactoryRegistry;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SoapMessageContext
extends BaseMessageContext
implements SOAPMessageContext {
    private static final Log log = LogFactory.getLog(SoapMessageContext.class);
    Message cachedMessage = null;
    SOAPMessage cachedSoapMessage = null;

    public SoapMessageContext(MessageContext messageCtx) {
        super(messageCtx);
    }

    public Object[] getHeaders(QName qname, JAXBContext jaxbcontext, boolean allRoles) {
        List<Block> blockList;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Getting all Headers for Qname: " + qname));
        }
        if (qname == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Invalid QName, QName cannot be null");
            }
            throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"soapMessageContextErr1"));
        }
        if (jaxbcontext == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Invalid JAXBContext, JAXBContext cannot be null");
            }
            throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"SOAPMessageContextErr2"));
        }
        ArrayList<Object> list = new ArrayList<Object>();
        String namespace = qname.getNamespaceURI();
        String localPart = qname.getLocalPart();
        JAXBBlockFactory blockFactory = (JAXBBlockFactory)FactoryRegistry.getFactory(JAXBBlockFactory.class);
        Message m = this.messageCtx.getMessage();
        JAXBBlockContext jbc = new JAXBBlockContext(jaxbcontext);
        RolePlayer rolePlayer = null;
        if (!allRoles) {
            rolePlayer = this.getRolePlayer();
        }
        if (m.getNumHeaderBlocks() > 0 && (blockList = m.getHeaderBlocks(namespace, localPart, jbc, blockFactory, rolePlayer)) != null && blockList.size() > 0) {
            try {
                for (Block block : blockList) {
                    Object bo = block.getBusinessObject(false);
                    if (bo == null) continue;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Extracted BO from Header Block");
                    }
                    list.add(bo);
                }
            }
            catch (XMLStreamException e) {
                throw ExceptionFactory.makeWebServiceException((Throwable)e);
            }
        }
        return list.toArray(new Object[0]);
    }

    public SOAPMessage getMessage() {
        Message msg = this.messageCtx.getMEPContext().getMessageObject();
        if (msg != this.cachedMessage) {
            this.cachedMessage = msg;
            this.cachedSoapMessage = msg.getAsSOAPMessage();
        }
        return this.cachedSoapMessage;
    }

    public Set<String> getRoles() {
        HashSet<String> roles = new HashSet<String>(3);
        roles.add("http://schemas.xmlsoap.org/soap/actor/next");
        roles.add("http://www.w3.org/2003/05/soap-envelope/role/ultimateReceiver");
        roles.add("http://www.w3.org/2003/05/soap-envelope/role/next");
        return roles;
    }

    public void setMessage(SOAPMessage soapmessage) {
        try {
            Message msg = ((MessageFactory)FactoryRegistry.getFactory(MessageFactory.class)).createFrom(soapmessage);
            this.messageCtx.getMEPContext().setMessage(msg);
            this.cachedMessage = msg;
            this.cachedSoapMessage = soapmessage;
        }
        catch (XMLStreamException xMLStreamException) {
            // empty catch block
        }
    }

    private RolePlayer getRolePlayer() {
        ArrayList<String> roles = new ArrayList<String>(this.getRoles());
        return new SMCRolePlayer(roles);
    }

    class SMCRolePlayer
    implements RolePlayer {
        private List roles;

        SMCRolePlayer(List roles) {
            this.roles = roles;
        }

        public List getRoles() {
            return this.roles;
        }

        public boolean isUltimateDestination() {
            return true;
        }
    }
}

