/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.net.messaging;

import com.icesoft.net.messaging.Message;
import com.icesoft.net.messaging.MessageHandler;
import com.icesoft.net.messaging.MessageSelector;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractMessageHandler
implements MessageHandler {
    private static final Log LOG = LogFactory.getLog((Class)AbstractMessageHandler.class);
    protected final Map callbackMap = new HashMap();
    protected MessageSelector messageSelector;

    protected AbstractMessageHandler() {
        this(null);
    }

    protected AbstractMessageHandler(MessageSelector messageSelector) {
        this.messageSelector = messageSelector;
    }

    public void addCallback(MessageHandler.Callback callback) {
        this.addCallback(callback, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCallback(MessageHandler.Callback callback, MessageSelector messageSelector) {
        if (callback != null) {
            Map map = this.callbackMap;
            synchronized (map) {
                this.callbackMap.put(callback, messageSelector);
            }
        }
    }

    public MessageSelector getMessageSelector() {
        return this.messageSelector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCallback(MessageHandler.Callback callback) {
        if (callback != null && this.callbackMap.containsKey(callback)) {
            Map map = this.callbackMap;
            synchronized (map) {
                if (this.callbackMap.containsKey(callback)) {
                    this.callbackMap.remove(callback);
                }
            }
        }
    }

    public void setMessageSelector(MessageSelector messageSelector) {
        this.messageSelector = messageSelector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MessageHandler.Callback[] getCallbacks(Message message) {
        ArrayList _callbackList = new ArrayList();
        if (message != null) {
            Map map = this.callbackMap;
            synchronized (map) {
                Set _entrySet = this.callbackMap.entrySet();
                int _size = _entrySet.size();
                Iterator _entries = _entrySet.iterator();
                for (int i = 0; i < _size; ++i) {
                    Map.Entry _entry = _entries.next();
                    MessageSelector _messageSelector = (MessageSelector)_entry.getValue();
                    if (_messageSelector != null && !_messageSelector.matches(message)) continue;
                    _callbackList.add(_entry.getKey());
                }
            }
        }
        return _callbackList.toArray(new MessageHandler.Callback[_callbackList.size()]);
    }
}

