/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.renderkit.dom_html_basic;

import com.icesoft.faces.component.AttributeConstants;
import com.icesoft.faces.context.DOMContext;
import com.icesoft.faces.context.effects.JavascriptContext;
import com.icesoft.faces.renderkit.dom_html_basic.DomBasicRenderer;
import com.icesoft.faces.renderkit.dom_html_basic.PassThruAttributeRenderer;
import java.io.IOException;
import java.util.Map;
import javax.faces.component.UICommand;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import javax.faces.event.FacesEvent;
import org.w3c.dom.Element;

public class ButtonRenderer
extends DomBasicRenderer {
    private static final String[] passThruAttributes = AttributeConstants.getAttributes(0);

    public void decode(FacesContext facesContext, UIComponent uiComponent) {
        ButtonRenderer.validateParameters(facesContext, uiComponent, UICommand.class);
        if (ButtonRenderer.isStatic(uiComponent)) {
            return;
        }
        if (!this.didThisButtonInvokeSubmit(facesContext, uiComponent)) {
            return;
        }
        String type = ((String)uiComponent.getAttributes().get("type")).toLowerCase();
        if (type != null && type.equals("reset")) {
            return;
        }
        uiComponent.queueEvent((FacesEvent)new ActionEvent(uiComponent));
    }

    private boolean didThisButtonInvokeSubmit(FacesContext facesContext, UIComponent uiComponent) {
        Map requestParameterMap = facesContext.getExternalContext().getRequestParameterMap();
        String componentClientId = uiComponent.getClientId(facesContext);
        return requestParameterMap.containsKey(componentClientId);
    }

    public void encodeBegin(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        Element root;
        ButtonRenderer.validateParameters(facesContext, uiComponent, UICommand.class);
        DOMContext domContext = DOMContext.attachDOMContext(facesContext, uiComponent);
        String clientId = uiComponent.getClientId(facesContext);
        if (!domContext.isInitialized()) {
            root = domContext.createElement("input");
            domContext.setRootNode(root);
            root.setAttribute("name", clientId);
        }
        root = (Element)domContext.getRootNode();
        ButtonRenderer.setRootElementId(facesContext, root, uiComponent);
        String typeAttribute = (String)uiComponent.getAttributes().get("type");
        if (typeAttribute == null || !typeAttribute.equals("reset") && !typeAttribute.equals("button")) {
            typeAttribute = "submit";
        }
        typeAttribute = typeAttribute.toLowerCase();
        uiComponent.getAttributes().put("type", typeAttribute);
        String imageAttribute = (String)uiComponent.getAttributes().get("image");
        if (imageAttribute != null) {
            typeAttribute = "image";
            root.setAttribute("type", typeAttribute);
            String pathToImage = ButtonRenderer.getResourceURL(facesContext, imageAttribute);
            root.setAttribute("src", pathToImage);
            root.removeAttribute("value");
        } else {
            root.setAttribute("type", typeAttribute);
            String label = "";
            Object componentValue = ((UICommand)uiComponent).getValue();
            label = componentValue != null ? componentValue.toString() : "";
            root.setAttribute("value", label);
            root.removeAttribute("src");
        }
        String styleClass = (String)uiComponent.getAttributes().get("styleClass");
        if (styleClass != null) {
            root.setAttribute("class", styleClass);
        }
        JavascriptContext.fireEffect(uiComponent, facesContext);
        PassThruAttributeRenderer.renderHtmlAttributes(facesContext, uiComponent, passThruAttributes);
        PassThruAttributeRenderer.renderBooleanAttributes(facesContext, uiComponent, root, PassThruAttributeRenderer.EMPTY_STRING_ARRAY);
        if (typeAttribute.equals("submit") || typeAttribute.equals("image")) {
            this.renderOnClick(uiComponent, root);
        }
        domContext.stepOver();
    }

    protected void renderOnClick(UIComponent uiComponent, Element root) {
        String onclick = (String)uiComponent.getAttributes().get("onclick");
        String submitCode = "iceSubmit(form,this,event);" + "return false;";
        root.setAttribute("onclick", ButtonRenderer.combinedPassThru(onclick, submitCode));
    }

    public void encodeChildren(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        ButtonRenderer.validateParameters(facesContext, uiComponent, UICommand.class);
    }

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        ButtonRenderer.validateParameters(facesContext, uiComponent, UICommand.class);
    }
}

