/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.webapp.http.portlet.page;

import com.icesoft.faces.context.View;
import com.icesoft.faces.webapp.http.common.Configuration;
import com.icesoft.faces.webapp.http.portlet.page.AssociatedPageViews;
import com.icesoft.faces.webapp.http.portlet.page.NoOpAssociatedPageViews;
import com.icesoft.faces.webapp.http.portlet.page.ViewsPageBidiMap;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AssociatedPageViewsImpl
implements AssociatedPageViews {
    protected static final Log log = LogFactory.getLog((Class)AssociatedPageViews.class);
    private ViewsPageBidiMap bidi = new ViewsPageBidiMap();
    private static Class impl;

    public abstract String getPageId();

    public static AssociatedPageViews getImplementation(Configuration config) {
        if (impl == null) {
            String implName = config.getAttribute("portlet.associatedPageViewsImpl", "com.icesoft.faces.webapp.http.portlet.page.NoOpAssociatedPageViews");
            try {
                impl = Class.forName(implName);
            }
            catch (ClassNotFoundException cnfe1) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)("could not load " + implName));
                }
                Class clazz = impl = NoOpAssociatedPageViews.class;
            }
            if (log.isInfoEnabled()) {
                log.info((Object)("using " + impl.getName()));
            }
        }
        try {
            Object inst = impl.newInstance();
            return (AssociatedPageViews)inst;
        }
        catch (Exception e) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("could not create an instance of " + impl.getName()), (Throwable)e);
            }
            return new NoOpAssociatedPageViews();
        }
    }

    public void add(View view) {
        String pageId = this.getPageId();
        this.bidi.put(pageId, view);
    }

    public void disposeAssociatedViews(View view) {
        Set associatedViews = this.bidi.getAssociatedViews(view);
        Iterator views = associatedViews.iterator();
        while (views.hasNext()) {
            View v = (View)views.next();
            v.dispose();
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("disposed " + v.toString()));
        }
        this.bidi.clear();
    }
}

