/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.userdetails.checker;

import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.security.AccountExpiredException;
import org.springframework.security.CredentialsExpiredException;
import org.springframework.security.DisabledException;
import org.springframework.security.LockedException;
import org.springframework.security.SpringSecurityMessageSource;
import org.springframework.security.userdetails.UserDetails;
import org.springframework.security.userdetails.UserDetailsChecker;

public class AccountStatusUserDetailsChecker
implements UserDetailsChecker {
    protected MessageSourceAccessor messages = SpringSecurityMessageSource.getAccessor();

    public void check(UserDetails user) {
        if (!user.isAccountNonLocked()) {
            throw new LockedException(this.messages.getMessage("UserDetailsService.locked", "User account is locked"), user);
        }
        if (!user.isEnabled()) {
            throw new DisabledException(this.messages.getMessage("UserDetailsService.disabled", "User is disabled"), user);
        }
        if (!user.isAccountNonExpired()) {
            throw new AccountExpiredException(this.messages.getMessage("UserDetailsService.expired", "User account has expired"), user);
        }
        if (!user.isCredentialsNonExpired()) {
            throw new CredentialsExpiredException(this.messages.getMessage("UserDetailsService.credentialsExpired", "User credentials have expired"), user);
        }
    }
}

