/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.classloader;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.jar.Manifest;
import org.apache.axis2.classloader.AbstractUrlResourceLocation;
import org.apache.axis2.classloader.DirectoryResourceHandle;
import org.apache.axis2.classloader.IoUtil;
import org.apache.axis2.classloader.ResourceHandle;

public class DirectoryResourceLocation
extends AbstractUrlResourceLocation {
    private final File baseDir;
    private boolean manifestLoaded = false;
    private Manifest manifest;

    public DirectoryResourceLocation(File baseDir) throws MalformedURLException {
        super(baseDir.toURL());
        this.baseDir = baseDir;
    }

    public ResourceHandle getResourceHandle(String resourceName) {
        File file = new File(this.baseDir, resourceName);
        if (!file.exists() || !this.isLocal(file)) {
            return null;
        }
        try {
            DirectoryResourceHandle resourceHandle = new DirectoryResourceHandle(resourceName, file, this.baseDir, this.getManifestSafe());
            return resourceHandle;
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    private boolean isLocal(File file) {
        try {
            String base = this.baseDir.getCanonicalPath();
            String relative = file.getCanonicalPath();
            return relative.startsWith(base);
        }
        catch (IOException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Manifest getManifest() throws IOException {
        if (!this.manifestLoaded) {
            File manifestFile = new File(this.baseDir, "META-INF/MANIFEST.MF");
            if (manifestFile.isFile() && manifestFile.canRead()) {
                FileInputStream in = null;
                try {
                    in = new FileInputStream(manifestFile);
                    this.manifest = new Manifest(in);
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    IoUtil.close(in);
                    throw throwable;
                }
                IoUtil.close(in);
                {
                }
            }
            this.manifestLoaded = true;
        }
        return this.manifest;
    }

    private Manifest getManifestSafe() {
        Manifest manifest = null;
        try {
            manifest = this.getManifest();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return manifest;
    }
}

