/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.jalopy.swing.syntax;

import de.hunsicker.jalopy.swing.syntax.KeywordMap;
import de.hunsicker.jalopy.swing.syntax.TokenMarker;
import javax.swing.text.Segment;

public final class JavaTokenMarker
extends TokenMarker {
    private static KeywordMap cKeywords;
    private KeywordMap keywords;
    private boolean cpp;

    public JavaTokenMarker() {
        this(true, JavaTokenMarker.getKeywords());
    }

    public JavaTokenMarker(boolean cpp, KeywordMap keywords) {
        this.cpp = cpp;
        this.keywords = keywords;
    }

    public static KeywordMap getKeywords() {
        if (cKeywords == null) {
            cKeywords = new KeywordMap(false);
            cKeywords.add("package", (byte)8);
            cKeywords.add("import", (byte)8);
            cKeywords.add("class", (byte)8);
            cKeywords.add("interface", (byte)8);
            cKeywords.add("extends", (byte)8);
            cKeywords.add("implements", (byte)8);
            cKeywords.add("enum", (byte)8);
            cKeywords.add("@interface", (byte)8);
            cKeywords.add("@Target", (byte)8);
            cKeywords.add("@Retention", (byte)8);
            cKeywords.add("byte", (byte)9);
            cKeywords.add("char", (byte)9);
            cKeywords.add("short", (byte)9);
            cKeywords.add("int", (byte)9);
            cKeywords.add("long", (byte)9);
            cKeywords.add("float", (byte)9);
            cKeywords.add("double", (byte)9);
            cKeywords.add("boolean", (byte)9);
            cKeywords.add("void", (byte)9);
            cKeywords.add("abstract", (byte)7);
            cKeywords.add("final", (byte)7);
            cKeywords.add("private", (byte)7);
            cKeywords.add("protected", (byte)7);
            cKeywords.add("public", (byte)7);
            cKeywords.add("static", (byte)7);
            cKeywords.add("synchronized", (byte)7);
            cKeywords.add("volatile", (byte)7);
            cKeywords.add("transient", (byte)7);
            cKeywords.add("native", (byte)7);
            cKeywords.add("strictfp", (byte)7);
            cKeywords.add("break", (byte)7);
            cKeywords.add("case", (byte)7);
            cKeywords.add("continue", (byte)7);
            cKeywords.add("default", (byte)7);
            cKeywords.add("do", (byte)7);
            cKeywords.add("else", (byte)7);
            cKeywords.add("for", (byte)7);
            cKeywords.add("if", (byte)7);
            cKeywords.add("instanceof", (byte)7);
            cKeywords.add("new", (byte)7);
            cKeywords.add("return", (byte)7);
            cKeywords.add("switch", (byte)7);
            cKeywords.add("while", (byte)7);
            cKeywords.add("throw", (byte)7);
            cKeywords.add("try", (byte)7);
            cKeywords.add("catch", (byte)7);
            cKeywords.add("finally", (byte)7);
            cKeywords.add("throws", (byte)7);
            cKeywords.add("assert", (byte)7);
            cKeywords.add("this", (byte)5);
            cKeywords.add("null", (byte)5);
            cKeywords.add("super", (byte)5);
            cKeywords.add("true", (byte)5);
            cKeywords.add("false", (byte)5);
        }
        return cKeywords;
    }

    public byte markTokensImpl(byte token, Segment line, int lineIndex) {
        int len;
        byte id;
        int offset;
        char[] array = line.array;
        int lastOffset = offset = line.offset;
        int lastKeyword = offset;
        int newLength = line.count + offset;
        boolean backslash = false;
        int i = offset;
        block13: while (i < newLength) {
            int i1 = i + 1;
            char c = array[i];
            switch (c) {
                case '\\': {
                    backslash = !backslash;
                    break;
                }
                case '*': {
                    if (token != 1 && token != 2 && token != 3 || newLength - i <= 1) break;
                    backslash = false;
                    if (newLength - i <= 1 || array[i1] != '/') break;
                    this.addToken(++i + 1 - lastOffset, token);
                    token = 0;
                    lastKeyword = lastOffset = i + 1;
                    break;
                }
                case '#': {
                    backslash = false;
                    if (!this.cpp || token != 0) break;
                    token = (byte)8;
                    this.addToken(i - lastOffset, (byte)0);
                    this.addToken(newLength - i, (byte)8);
                    lastOffset = newLength;
                    break block13;
                }
                case '/': {
                    backslash = false;
                    if (token != 0 || newLength - i <= 1) break;
                    switch (array[i1]) {
                        case '*': {
                            this.addToken(i - lastOffset, token);
                            lastKeyword = lastOffset = i;
                            if (newLength - i > 2 && array[i + 2] == '*') {
                                token = (byte)2;
                                break;
                            }
                            if (newLength - i > 2 && array[i + 2] == '#') {
                                token = (byte)3;
                                break;
                            }
                            token = 1;
                            break;
                        }
                        case '/': {
                            this.addToken(i - lastOffset, token);
                            this.addToken(newLength - i, (byte)1);
                            lastKeyword = lastOffset = newLength;
                            break block13;
                        }
                    }
                    break;
                }
                case '\"': {
                    if (backslash) {
                        backslash = false;
                        break;
                    }
                    if (token == 0) {
                        token = (byte)4;
                        this.addToken(i - lastOffset, (byte)0);
                        lastKeyword = lastOffset = i;
                        break;
                    }
                    if (token != 4) break;
                    token = 0;
                    this.addToken(i1 - lastOffset, (byte)4);
                    lastKeyword = lastOffset = i1;
                    break;
                }
                case '\'': {
                    if (backslash) {
                        backslash = false;
                        break;
                    }
                    if (token == 0) {
                        token = (byte)5;
                        this.addToken(i - lastOffset, (byte)0);
                        lastKeyword = lastOffset = i;
                        break;
                    }
                    if (token != 5) break;
                    token = 0;
                    this.addToken(i1 - lastOffset, (byte)4);
                    lastKeyword = lastOffset = i1;
                    break;
                }
                case ':': {
                    if (token == 0 && lastKeyword == offset) {
                        backslash = false;
                        this.addToken(i1 - lastOffset, (byte)6);
                        lastKeyword = lastOffset = i1;
                        break;
                    }
                }
                default: {
                    backslash = false;
                    if (token != 0 || c == '_' || Character.isLetter(c) || c == '@') break;
                    int len2 = i - lastKeyword;
                    byte id2 = this.keywords.lookup(line, lastKeyword, len2);
                    if (id2 != 0) {
                        if (lastKeyword != lastOffset) {
                            this.addToken(lastKeyword - lastOffset, (byte)0);
                        }
                        this.addToken(len2, id2);
                        lastOffset = i;
                    }
                    lastKeyword = i1;
                }
            }
            ++i;
        }
        if (token == 0 && (id = this.keywords.lookup(line, lastKeyword, len = newLength - lastKeyword)) != 0) {
            if (lastKeyword != lastOffset) {
                this.addToken(lastKeyword - lastOffset, (byte)0);
            }
            this.addToken(len, id);
            lastOffset = newLength;
        }
        if (lastOffset != newLength) {
            if (token == 4 || token == 5) {
                this.addToken(newLength - lastOffset, (byte)11);
                token = 0;
            } else {
                this.addToken(newLength - lastOffset, token);
            }
        }
        if (token == 8 && !backslash) {
            token = 0;
        }
        return token;
    }
}

